/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.functions.FunctionsManagementAsync;
import com.oracle.bmc.functions.internal.http.ChangeApplicationCompartmentConverter;
import com.oracle.bmc.functions.internal.http.CreateApplicationConverter;
import com.oracle.bmc.functions.internal.http.CreateFunctionConverter;
import com.oracle.bmc.functions.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.functions.internal.http.DeleteFunctionConverter;
import com.oracle.bmc.functions.internal.http.GetApplicationConverter;
import com.oracle.bmc.functions.internal.http.GetFunctionConverter;
import com.oracle.bmc.functions.internal.http.ListApplicationsConverter;
import com.oracle.bmc.functions.internal.http.ListFunctionsConverter;
import com.oracle.bmc.functions.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.functions.internal.http.UpdateFunctionConverter;
import com.oracle.bmc.functions.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.functions.requests.CreateApplicationRequest;
import com.oracle.bmc.functions.requests.CreateFunctionRequest;
import com.oracle.bmc.functions.requests.DeleteApplicationRequest;
import com.oracle.bmc.functions.requests.DeleteFunctionRequest;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.UpdateApplicationRequest;
import com.oracle.bmc.functions.requests.UpdateFunctionRequest;
import com.oracle.bmc.functions.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.functions.responses.CreateApplicationResponse;
import com.oracle.bmc.functions.responses.CreateFunctionResponse;
import com.oracle.bmc.functions.responses.DeleteApplicationResponse;
import com.oracle.bmc.functions.responses.DeleteFunctionResponse;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.UpdateApplicationResponse;
import com.oracle.bmc.functions.responses.UpdateFunctionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManagementAsyncClient
implements FunctionsManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionsManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FUNCTIONSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://functions.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request, AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handler) {
        LOG.trace("Called async changeApplicationCompartment");
        final ChangeApplicationCompartmentRequest interceptedRequest = ChangeApplicationCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeApplicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeApplicationCompartmentResponse> transformer = ChangeApplicationCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> onSuccess = new SuccessConsumer<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeApplicationCompartmentRequest> onError = new ErrorConsumer<ChangeApplicationCompartmentRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeApplicationCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeApplicationCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeApplicationCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeApplicationCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeApplicationCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeApplicationCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeApplicationCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        LOG.trace("Called async createApplication");
        final CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateApplicationRequest, CreateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateApplicationRequest, CreateApplicationResponse> onSuccess = new SuccessConsumer<CreateApplicationRequest, CreateApplicationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateApplicationRequest> onError = new ErrorConsumer<CreateApplicationRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateApplicationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateApplicationRequest, CreateApplicationResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateApplicationRequest, CreateApplicationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateApplicationRequest> onError = handler == null ? null : new ErrorConsumer<CreateApplicationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateApplicationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateApplicationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateApplicationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateApplicationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateFunctionResponse> createFunction(CreateFunctionRequest request, AsyncHandler<CreateFunctionRequest, CreateFunctionResponse> handler) {
        LOG.trace("Called async createFunction");
        final CreateFunctionRequest interceptedRequest = CreateFunctionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateFunctionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateFunctionResponse> transformer = CreateFunctionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateFunctionRequest, CreateFunctionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateFunctionRequest, CreateFunctionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateFunctionRequest, CreateFunctionResponse> onSuccess = new SuccessConsumer<CreateFunctionRequest, CreateFunctionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateFunctionRequest> onError = new ErrorConsumer<CreateFunctionRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateFunctionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateFunctionRequest, CreateFunctionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateFunctionRequest, CreateFunctionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateFunctionRequest> onError = handler == null ? null : new ErrorConsumer<CreateFunctionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateFunctionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateFunctionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateFunctionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateFunctionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        LOG.trace("Called async deleteApplication");
        final DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteApplicationRequest, DeleteApplicationResponse> onSuccess = new SuccessConsumer<DeleteApplicationRequest, DeleteApplicationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteApplicationRequest> onError = new ErrorConsumer<DeleteApplicationRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteApplicationRequest, DeleteApplicationResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteApplicationRequest, DeleteApplicationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteApplicationRequest> onError = handler == null ? null : new ErrorConsumer<DeleteApplicationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteApplicationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteApplicationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest request, AsyncHandler<DeleteFunctionRequest, DeleteFunctionResponse> handler) {
        LOG.trace("Called async deleteFunction");
        final DeleteFunctionRequest interceptedRequest = DeleteFunctionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteFunctionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteFunctionResponse> transformer = DeleteFunctionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteFunctionRequest, DeleteFunctionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteFunctionRequest, DeleteFunctionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteFunctionRequest, DeleteFunctionResponse> onSuccess = new SuccessConsumer<DeleteFunctionRequest, DeleteFunctionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteFunctionRequest> onError = new ErrorConsumer<DeleteFunctionRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteFunctionRequest, DeleteFunctionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteFunctionRequest, DeleteFunctionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteFunctionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteFunctionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteFunctionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteFunctionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        LOG.trace("Called async getApplication");
        final GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetApplicationRequest, GetApplicationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetApplicationRequest, GetApplicationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetApplicationRequest, GetApplicationResponse> onSuccess = new SuccessConsumer<GetApplicationRequest, GetApplicationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetApplicationRequest> onError = new ErrorConsumer<GetApplicationRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetApplicationRequest, GetApplicationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetApplicationRequest, GetApplicationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetApplicationRequest> onError = handler == null ? null : new ErrorConsumer<GetApplicationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetApplicationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetApplicationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetFunctionResponse> getFunction(GetFunctionRequest request, AsyncHandler<GetFunctionRequest, GetFunctionResponse> handler) {
        LOG.trace("Called async getFunction");
        final GetFunctionRequest interceptedRequest = GetFunctionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetFunctionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetFunctionResponse> transformer = GetFunctionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetFunctionRequest, GetFunctionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetFunctionRequest, GetFunctionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetFunctionRequest, GetFunctionResponse> onSuccess = new SuccessConsumer<GetFunctionRequest, GetFunctionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetFunctionRequest> onError = new ErrorConsumer<GetFunctionRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetFunctionRequest, GetFunctionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetFunctionRequest, GetFunctionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetFunctionRequest> onError = handler == null ? null : new ErrorConsumer<GetFunctionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetFunctionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetFunctionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        LOG.trace("Called async listApplications");
        final ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListApplicationsRequest, ListApplicationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListApplicationsRequest, ListApplicationsResponse> onSuccess = new SuccessConsumer<ListApplicationsRequest, ListApplicationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListApplicationsRequest> onError = new ErrorConsumer<ListApplicationsRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListApplicationsRequest, ListApplicationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListApplicationsRequest, ListApplicationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListApplicationsRequest> onError = handler == null ? null : new ErrorConsumer<ListApplicationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListApplicationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListApplicationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListFunctionsResponse> listFunctions(ListFunctionsRequest request, AsyncHandler<ListFunctionsRequest, ListFunctionsResponse> handler) {
        LOG.trace("Called async listFunctions");
        final ListFunctionsRequest interceptedRequest = ListFunctionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListFunctionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListFunctionsResponse> transformer = ListFunctionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListFunctionsRequest, ListFunctionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListFunctionsRequest, ListFunctionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListFunctionsRequest, ListFunctionsResponse> onSuccess = new SuccessConsumer<ListFunctionsRequest, ListFunctionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListFunctionsRequest> onError = new ErrorConsumer<ListFunctionsRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListFunctionsRequest, ListFunctionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListFunctionsRequest, ListFunctionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListFunctionsRequest> onError = handler == null ? null : new ErrorConsumer<ListFunctionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListFunctionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListFunctionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        LOG.trace("Called async updateApplication");
        final UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateApplicationRequest, UpdateApplicationResponse> onSuccess = new SuccessConsumer<UpdateApplicationRequest, UpdateApplicationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateApplicationRequest> onError = new ErrorConsumer<UpdateApplicationRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateApplicationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateApplicationRequest, UpdateApplicationResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateApplicationRequest, UpdateApplicationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateApplicationRequest> onError = handler == null ? null : new ErrorConsumer<UpdateApplicationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateApplicationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateApplicationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateApplicationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateApplicationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest request, AsyncHandler<UpdateFunctionRequest, UpdateFunctionResponse> handler) {
        LOG.trace("Called async updateFunction");
        final UpdateFunctionRequest interceptedRequest = UpdateFunctionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateFunctionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateFunctionResponse> transformer = UpdateFunctionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateFunctionRequest, UpdateFunctionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateFunctionRequest, UpdateFunctionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateFunctionRequest, UpdateFunctionResponse> onSuccess = new SuccessConsumer<UpdateFunctionRequest, UpdateFunctionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateFunctionRequest> onError = new ErrorConsumer<UpdateFunctionRequest>(this, interceptedRequest);
                    FunctionsManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateFunctionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateFunctionRequest, UpdateFunctionResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateFunctionRequest, UpdateFunctionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateFunctionRequest> onError = handler == null ? null : new ErrorConsumer<UpdateFunctionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateFunctionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateFunctionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FunctionsManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateFunctionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateFunctionResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FunctionsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public FunctionsManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new FunctionsManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

