/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.functions.FunctionsManagement;
import com.oracle.bmc.functions.FunctionsManagementPaginators;
import com.oracle.bmc.functions.FunctionsManagementWaiters;
import com.oracle.bmc.functions.internal.http.ChangeApplicationCompartmentConverter;
import com.oracle.bmc.functions.internal.http.CreateApplicationConverter;
import com.oracle.bmc.functions.internal.http.CreateFunctionConverter;
import com.oracle.bmc.functions.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.functions.internal.http.DeleteFunctionConverter;
import com.oracle.bmc.functions.internal.http.GetApplicationConverter;
import com.oracle.bmc.functions.internal.http.GetFunctionConverter;
import com.oracle.bmc.functions.internal.http.ListApplicationsConverter;
import com.oracle.bmc.functions.internal.http.ListFunctionsConverter;
import com.oracle.bmc.functions.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.functions.internal.http.UpdateFunctionConverter;
import com.oracle.bmc.functions.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.functions.requests.CreateApplicationRequest;
import com.oracle.bmc.functions.requests.CreateFunctionRequest;
import com.oracle.bmc.functions.requests.DeleteApplicationRequest;
import com.oracle.bmc.functions.requests.DeleteFunctionRequest;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.UpdateApplicationRequest;
import com.oracle.bmc.functions.requests.UpdateFunctionRequest;
import com.oracle.bmc.functions.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.functions.responses.CreateApplicationResponse;
import com.oracle.bmc.functions.responses.CreateFunctionResponse;
import com.oracle.bmc.functions.responses.DeleteApplicationResponse;
import com.oracle.bmc.functions.responses.DeleteFunctionResponse;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.UpdateApplicationResponse;
import com.oracle.bmc.functions.responses.UpdateFunctionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManagementClient
implements FunctionsManagement {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionsManagementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FUNCTIONSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://functions.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final FunctionsManagementWaiters waiters;
    private final FunctionsManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public FunctionsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public FunctionsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public FunctionsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public FunctionsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public FunctionsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public FunctionsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public FunctionsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public FunctionsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FunctionsManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new FunctionsManagementWaiters(executorService, this);
        this.paginators = new FunctionsManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeApplicationCompartmentResponse changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        LOG.trace("Called changeApplicationCompartment");
        ChangeApplicationCompartmentRequest interceptedRequest = ChangeApplicationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApplicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApplicationCompartmentResponse> transformer = ChangeApplicationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeApplicationCompartmentDetails(), retriedRequest);
                return (ChangeApplicationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        LOG.trace("Called createApplication");
        CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateApplicationDetails(), retriedRequest);
                return (CreateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest request) {
        LOG.trace("Called createFunction");
        CreateFunctionRequest interceptedRequest = CreateFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFunctionResponse> transformer = CreateFunctionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateFunctionDetails(), retriedRequest);
                return (CreateFunctionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest request) {
        LOG.trace("Called deleteApplication");
        DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest request) {
        LOG.trace("Called deleteFunction");
        DeleteFunctionRequest interceptedRequest = DeleteFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFunctionResponse> transformer = DeleteFunctionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteFunctionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest request) {
        LOG.trace("Called getApplication");
        GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest request) {
        LOG.trace("Called getFunction");
        GetFunctionRequest interceptedRequest = GetFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFunctionResponse> transformer = GetFunctionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetFunctionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest request) {
        LOG.trace("Called listApplications");
        ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListApplicationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest request) {
        LOG.trace("Called listFunctions");
        ListFunctionsRequest interceptedRequest = ListFunctionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFunctionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFunctionsResponse> transformer = ListFunctionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListFunctionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest request) {
        LOG.trace("Called updateApplication");
        UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateApplicationDetails(), retriedRequest);
                return (UpdateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest request) {
        LOG.trace("Called updateFunction");
        UpdateFunctionRequest interceptedRequest = UpdateFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateFunctionResponse> transformer = UpdateFunctionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateFunctionDetails(), retriedRequest);
                return (UpdateFunctionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public FunctionsManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public FunctionsManagementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FunctionsManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public FunctionsManagementClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new FunctionsManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

