/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.functions.requests.InvokeFunctionRequest;
import com.oracle.bmc.functions.responses.InvokeFunctionResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeFunctionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeFunctionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static InvokeFunctionRequest interceptRequest(InvokeFunctionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, InvokeFunctionRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getFunctionId(), (String)"functionId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("functions").path(HttpUtils.encodePathSegment(request.getFunctionId())).path("actions").path("invoke");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("*/*");
        if (request.getFnIntent() != null) {
            ib.header("fn-intent", request.getFnIntent().getValue());
        }
        if (request.getFnInvokeType() != null) {
            ib.header("fn-invoke-type", request.getFnInvokeType().getValue());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, InvokeFunctionResponse> fromResponse() {
        Function<Response, InvokeFunctionResponse> transformer = new Function<Response, InvokeFunctionResponse>(){

            public InvokeFunctionResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for InvokeFunctionResponse");
                Function<Response, WithHeaders<InputStream>> responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                InvokeFunctionResponse.Builder builder = InvokeFunctionResponse.builder();
                builder.inputStream((InputStream)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                InvokeFunctionResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

