/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.functions.model.CreateFunctionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateFunctionRequest
extends BmcRequest {
    private CreateFunctionDetails createFunctionDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"createFunctionDetails", "opcRequestId"})
    CreateFunctionRequest(CreateFunctionDetails createFunctionDetails, String opcRequestId) {
        this.createFunctionDetails = createFunctionDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateFunctionDetails getCreateFunctionDetails() {
        return this.createFunctionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateFunctionDetails createFunctionDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateFunctionRequest o) {
            this.createFunctionDetails(o.getCreateFunctionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateFunctionRequest build() {
            CreateFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createFunctionDetails(CreateFunctionDetails createFunctionDetails) {
            this.createFunctionDetails = createFunctionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateFunctionRequest buildWithoutInvocationCallback() {
            return new CreateFunctionRequest(this.createFunctionDetails, this.opcRequestId);
        }

        public String toString() {
            return "CreateFunctionRequest.Builder(createFunctionDetails=" + this.createFunctionDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

