/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.functions.model.Function;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListFunctionsRequest
extends BmcRequest {
    private String applicationId;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private Function.LifecycleState lifecycleState;
    private String displayName;
    private String id;
    private SortOrder sortOrder;
    private SortBy sortBy;

    @ConstructorProperties(value={"applicationId", "limit", "page", "opcRequestId", "lifecycleState", "displayName", "id", "sortOrder", "sortBy"})
    ListFunctionsRequest(String applicationId, Integer limit, String page, String opcRequestId, Function.LifecycleState lifecycleState, String displayName, String id, SortOrder sortOrder, SortBy sortBy) {
        this.applicationId = applicationId;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.id = id;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Function.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public static class Builder {
        private String applicationId;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Function.LifecycleState lifecycleState;
        private String displayName;
        private String id;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFunctionsRequest o) {
            this.applicationId(o.getApplicationId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.id(o.getId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFunctionsRequest build() {
            ListFunctionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lifecycleState(Function.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListFunctionsRequest buildWithoutInvocationCallback() {
            return new ListFunctionsRequest(this.applicationId, this.limit, this.page, this.opcRequestId, this.lifecycleState, this.displayName, this.id, this.sortOrder, this.sortBy);
        }

        public String toString() {
            return "ListFunctionsRequest.Builder(applicationId=" + this.applicationId + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ", id=" + this.id + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        Id("id"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

