/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.functions.model.UpdateApplicationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateApplicationRequest
extends BmcRequest {
    private String applicationId;
    private UpdateApplicationDetails updateApplicationDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"applicationId", "updateApplicationDetails", "ifMatch", "opcRequestId"})
    UpdateApplicationRequest(String applicationId, UpdateApplicationDetails updateApplicationDetails, String ifMatch, String opcRequestId) {
        this.applicationId = applicationId;
        this.updateApplicationDetails = updateApplicationDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public UpdateApplicationDetails getUpdateApplicationDetails() {
        return this.updateApplicationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String applicationId;
        private UpdateApplicationDetails updateApplicationDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateApplicationRequest o) {
            this.applicationId(o.getApplicationId());
            this.updateApplicationDetails(o.getUpdateApplicationDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateApplicationRequest build() {
            UpdateApplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder updateApplicationDetails(UpdateApplicationDetails updateApplicationDetails) {
            this.updateApplicationDetails = updateApplicationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateApplicationRequest buildWithoutInvocationCallback() {
            return new UpdateApplicationRequest(this.applicationId, this.updateApplicationDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateApplicationRequest.Builder(applicationId=" + this.applicationId + ", updateApplicationDetails=" + this.updateApplicationDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

