/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.functions.model.UpdateFunctionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateFunctionRequest
extends BmcRequest {
    private String functionId;
    private UpdateFunctionDetails updateFunctionDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"functionId", "updateFunctionDetails", "ifMatch", "opcRequestId"})
    UpdateFunctionRequest(String functionId, UpdateFunctionDetails updateFunctionDetails, String ifMatch, String opcRequestId) {
        this.functionId = functionId;
        this.updateFunctionDetails = updateFunctionDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public UpdateFunctionDetails getUpdateFunctionDetails() {
        return this.updateFunctionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String functionId;
        private UpdateFunctionDetails updateFunctionDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateFunctionRequest o) {
            this.functionId(o.getFunctionId());
            this.updateFunctionDetails(o.getUpdateFunctionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateFunctionRequest build() {
            UpdateFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder updateFunctionDetails(UpdateFunctionDetails updateFunctionDetails) {
            this.updateFunctionDetails = updateFunctionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateFunctionRequest buildWithoutInvocationCallback() {
            return new UpdateFunctionRequest(this.functionId, this.updateFunctionDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateFunctionRequest.Builder(functionId=" + this.functionId + ", updateFunctionDetails=" + this.updateFunctionDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

