/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.responses;

import com.oracle.bmc.functions.model.Function;
import java.beans.ConstructorProperties;

public class GetFunctionResponse {
    private String etag;
    private String opcRequestId;
    private Function function;

    @ConstructorProperties(value={"etag", "opcRequestId", "function"})
    GetFunctionResponse(String etag, String opcRequestId, Function function) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.function = function;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Function getFunction() {
        return this.function;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Function function;

        public Builder copy(GetFunctionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.function(o.getFunction());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder function(Function function) {
            this.function = function;
            return this;
        }

        public GetFunctionResponse build() {
            return new GetFunctionResponse(this.etag, this.opcRequestId, this.function);
        }

        public String toString() {
            return "GetFunctionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", function=" + this.function + ")";
        }
    }
}

