/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.responses;

import java.beans.ConstructorProperties;
import java.io.InputStream;

public class InvokeFunctionResponse {
    private String opcRequestId;
    private InputStream inputStream;

    @ConstructorProperties(value={"opcRequestId", "inputStream"})
    InvokeFunctionResponse(String opcRequestId, InputStream inputStream) {
        this.opcRequestId = opcRequestId;
        this.inputStream = inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public static class Builder {
        private String opcRequestId;
        private InputStream inputStream;

        public Builder copy(InvokeFunctionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.inputStream(o.getInputStream());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public InvokeFunctionResponse build() {
            return new InvokeFunctionResponse(this.opcRequestId, this.inputStream);
        }

        public String toString() {
            return "InvokeFunctionResponse.Builder(opcRequestId=" + this.opcRequestId + ", inputStream=" + this.inputStream + ")";
        }
    }
}

