/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.responses;

import com.oracle.bmc.functions.model.ApplicationSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListApplicationsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<ApplicationSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListApplicationsResponse(String opcNextPage, String opcRequestId, List<ApplicationSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ApplicationSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<ApplicationSummary> items;

        public Builder copy(ListApplicationsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ApplicationSummary> items) {
            this.items = items;
            return this;
        }

        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListApplicationsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

