/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.responses;

import com.oracle.bmc.functions.model.FunctionSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListFunctionsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<FunctionSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListFunctionsResponse(String opcNextPage, String opcRequestId, List<FunctionSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<FunctionSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<FunctionSummary> items;

        public Builder copy(ListFunctionsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<FunctionSummary> items) {
            this.items = items;
            return this;
        }

        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListFunctionsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

