/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.responses;

import com.oracle.bmc.functions.model.Application;
import java.beans.ConstructorProperties;

public class UpdateApplicationResponse {
    private String etag;
    private String opcRequestId;
    private Application application;

    @ConstructorProperties(value={"etag", "opcRequestId", "application"})
    UpdateApplicationResponse(String etag, String opcRequestId, Application application) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.application = application;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Application getApplication() {
        return this.application;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Application application;

        public Builder copy(UpdateApplicationResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.application(o.getApplication());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder application(Application application) {
            this.application = application;
            return this;
        }

        public UpdateApplicationResponse build() {
            return new UpdateApplicationResponse(this.etag, this.opcRequestId, this.application);
        }

        public String toString() {
            return "UpdateApplicationResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", application=" + this.application + ")";
        }
    }
}

