/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.healthchecks.HealthChecksAsync;
import com.oracle.bmc.healthchecks.internal.http.ChangeHttpMonitorCompartmentConverter;
import com.oracle.bmc.healthchecks.internal.http.ChangePingMonitorCompartmentConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateOnDemandHttpProbeConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateOnDemandPingProbeConverter;
import com.oracle.bmc.healthchecks.internal.http.CreatePingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.DeleteHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.DeletePingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.GetHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.GetPingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHealthChecksVantagePointsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHttpMonitorsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHttpProbeResultsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListPingMonitorsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListPingProbeResultsConverter;
import com.oracle.bmc.healthchecks.internal.http.UpdateHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.UpdatePingMonitorConverter;
import com.oracle.bmc.healthchecks.requests.ChangeHttpMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.ChangePingMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.CreateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandHttpProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandPingProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreatePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeleteHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeletePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetPingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.ListHealthChecksVantagePointsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.UpdateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.UpdatePingMonitorRequest;
import com.oracle.bmc.healthchecks.responses.ChangeHttpMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.ChangePingMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.CreateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandHttpProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandPingProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreatePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeleteHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeletePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetPingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.ListHealthChecksVantagePointsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.UpdateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecksAsyncClient
implements HealthChecksAsync {
    private static final Logger LOG = LoggerFactory.getLogger(HealthChecksAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("HEALTHCHECKS").serviceEndpointPrefix("healthchecks").serviceEndpointTemplate("https://healthchecks.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public HealthChecksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public HealthChecksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public HealthChecksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeHttpMonitorCompartmentResponse> changeHttpMonitorCompartment(ChangeHttpMonitorCompartmentRequest request, AsyncHandler<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse> handler) {
        LOG.trace("Called async changeHttpMonitorCompartment");
        final ChangeHttpMonitorCompartmentRequest interceptedRequest = ChangeHttpMonitorCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeHttpMonitorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeHttpMonitorCompartmentResponse> transformer = ChangeHttpMonitorCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse> onSuccess = new SuccessConsumer<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeHttpMonitorCompartmentRequest> onError = new ErrorConsumer<ChangeHttpMonitorCompartmentRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getChangeHttpMonitorCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeHttpMonitorCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeHttpMonitorCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeHttpMonitorCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeHttpMonitorCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getChangeHttpMonitorCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeHttpMonitorCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangePingMonitorCompartmentResponse> changePingMonitorCompartment(ChangePingMonitorCompartmentRequest request, AsyncHandler<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse> handler) {
        LOG.trace("Called async changePingMonitorCompartment");
        final ChangePingMonitorCompartmentRequest interceptedRequest = ChangePingMonitorCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangePingMonitorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangePingMonitorCompartmentResponse> transformer = ChangePingMonitorCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse> onSuccess = new SuccessConsumer<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangePingMonitorCompartmentRequest> onError = new ErrorConsumer<ChangePingMonitorCompartmentRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getChangePingMonitorCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangePingMonitorCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangePingMonitorCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangePingMonitorCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangePingMonitorCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getChangePingMonitorCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangePingMonitorCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateHttpMonitorResponse> createHttpMonitor(CreateHttpMonitorRequest request, AsyncHandler<CreateHttpMonitorRequest, CreateHttpMonitorResponse> handler) {
        LOG.trace("Called async createHttpMonitor");
        final CreateHttpMonitorRequest interceptedRequest = CreateHttpMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateHttpMonitorResponse> transformer = CreateHttpMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateHttpMonitorRequest, CreateHttpMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateHttpMonitorRequest, CreateHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateHttpMonitorRequest, CreateHttpMonitorResponse> onSuccess = new SuccessConsumer<CreateHttpMonitorRequest, CreateHttpMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateHttpMonitorRequest> onError = new ErrorConsumer<CreateHttpMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreateHttpMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateHttpMonitorRequest, CreateHttpMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateHttpMonitorRequest, CreateHttpMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateHttpMonitorRequest> onError = handler == null ? null : new ErrorConsumer<CreateHttpMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateHttpMonitorDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateHttpMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreateHttpMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateHttpMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateOnDemandHttpProbeResponse> createOnDemandHttpProbe(CreateOnDemandHttpProbeRequest request, AsyncHandler<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse> handler) {
        LOG.trace("Called async createOnDemandHttpProbe");
        final CreateOnDemandHttpProbeRequest interceptedRequest = CreateOnDemandHttpProbeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateOnDemandHttpProbeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateOnDemandHttpProbeResponse> transformer = CreateOnDemandHttpProbeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse> onSuccess = new SuccessConsumer<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateOnDemandHttpProbeRequest> onError = new ErrorConsumer<CreateOnDemandHttpProbeRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreateOnDemandHttpProbeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateOnDemandHttpProbeRequest> onError = handler == null ? null : new ErrorConsumer<CreateOnDemandHttpProbeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateOnDemandHttpProbeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateOnDemandHttpProbeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreateOnDemandHttpProbeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateOnDemandHttpProbeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateOnDemandPingProbeResponse> createOnDemandPingProbe(CreateOnDemandPingProbeRequest request, AsyncHandler<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse> handler) {
        LOG.trace("Called async createOnDemandPingProbe");
        final CreateOnDemandPingProbeRequest interceptedRequest = CreateOnDemandPingProbeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateOnDemandPingProbeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateOnDemandPingProbeResponse> transformer = CreateOnDemandPingProbeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse> onSuccess = new SuccessConsumer<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateOnDemandPingProbeRequest> onError = new ErrorConsumer<CreateOnDemandPingProbeRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreateOnDemandPingProbeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateOnDemandPingProbeRequest> onError = handler == null ? null : new ErrorConsumer<CreateOnDemandPingProbeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateOnDemandPingProbeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateOnDemandPingProbeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreateOnDemandPingProbeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateOnDemandPingProbeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreatePingMonitorResponse> createPingMonitor(CreatePingMonitorRequest request, AsyncHandler<CreatePingMonitorRequest, CreatePingMonitorResponse> handler) {
        LOG.trace("Called async createPingMonitor");
        final CreatePingMonitorRequest interceptedRequest = CreatePingMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreatePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreatePingMonitorResponse> transformer = CreatePingMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreatePingMonitorRequest, CreatePingMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreatePingMonitorRequest, CreatePingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreatePingMonitorRequest, CreatePingMonitorResponse> onSuccess = new SuccessConsumer<CreatePingMonitorRequest, CreatePingMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreatePingMonitorRequest> onError = new ErrorConsumer<CreatePingMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreatePingMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreatePingMonitorRequest, CreatePingMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreatePingMonitorRequest, CreatePingMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreatePingMonitorRequest> onError = handler == null ? null : new ErrorConsumer<CreatePingMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreatePingMonitorDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreatePingMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.post(ib, interceptedRequest.getCreatePingMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreatePingMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteHttpMonitorResponse> deleteHttpMonitor(DeleteHttpMonitorRequest request, AsyncHandler<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse> handler) {
        LOG.trace("Called async deleteHttpMonitor");
        final DeleteHttpMonitorRequest interceptedRequest = DeleteHttpMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteHttpMonitorResponse> transformer = DeleteHttpMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse> onSuccess = new SuccessConsumer<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteHttpMonitorRequest> onError = new ErrorConsumer<DeleteHttpMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteHttpMonitorRequest> onError = handler == null ? null : new ErrorConsumer<DeleteHttpMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteHttpMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteHttpMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeletePingMonitorResponse> deletePingMonitor(DeletePingMonitorRequest request, AsyncHandler<DeletePingMonitorRequest, DeletePingMonitorResponse> handler) {
        LOG.trace("Called async deletePingMonitor");
        final DeletePingMonitorRequest interceptedRequest = DeletePingMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeletePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeletePingMonitorResponse> transformer = DeletePingMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeletePingMonitorRequest, DeletePingMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeletePingMonitorRequest, DeletePingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeletePingMonitorRequest, DeletePingMonitorResponse> onSuccess = new SuccessConsumer<DeletePingMonitorRequest, DeletePingMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeletePingMonitorRequest> onError = new ErrorConsumer<DeletePingMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeletePingMonitorRequest, DeletePingMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeletePingMonitorRequest, DeletePingMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeletePingMonitorRequest> onError = handler == null ? null : new ErrorConsumer<DeletePingMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeletePingMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeletePingMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetHttpMonitorResponse> getHttpMonitor(GetHttpMonitorRequest request, AsyncHandler<GetHttpMonitorRequest, GetHttpMonitorResponse> handler) {
        LOG.trace("Called async getHttpMonitor");
        final GetHttpMonitorRequest interceptedRequest = GetHttpMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetHttpMonitorResponse> transformer = GetHttpMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetHttpMonitorRequest, GetHttpMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetHttpMonitorRequest, GetHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetHttpMonitorRequest, GetHttpMonitorResponse> onSuccess = new SuccessConsumer<GetHttpMonitorRequest, GetHttpMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetHttpMonitorRequest> onError = new ErrorConsumer<GetHttpMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetHttpMonitorRequest, GetHttpMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetHttpMonitorRequest, GetHttpMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetHttpMonitorRequest> onError = handler == null ? null : new ErrorConsumer<GetHttpMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetHttpMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetHttpMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPingMonitorResponse> getPingMonitor(GetPingMonitorRequest request, AsyncHandler<GetPingMonitorRequest, GetPingMonitorResponse> handler) {
        LOG.trace("Called async getPingMonitor");
        final GetPingMonitorRequest interceptedRequest = GetPingMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPingMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPingMonitorResponse> transformer = GetPingMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPingMonitorRequest, GetPingMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPingMonitorRequest, GetPingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPingMonitorRequest, GetPingMonitorResponse> onSuccess = new SuccessConsumer<GetPingMonitorRequest, GetPingMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPingMonitorRequest> onError = new ErrorConsumer<GetPingMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPingMonitorRequest, GetPingMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPingMonitorRequest, GetPingMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPingMonitorRequest> onError = handler == null ? null : new ErrorConsumer<GetPingMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPingMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPingMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListHealthChecksVantagePointsResponse> listHealthChecksVantagePoints(ListHealthChecksVantagePointsRequest request, AsyncHandler<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse> handler) {
        LOG.trace("Called async listHealthChecksVantagePoints");
        final ListHealthChecksVantagePointsRequest interceptedRequest = ListHealthChecksVantagePointsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListHealthChecksVantagePointsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListHealthChecksVantagePointsResponse> transformer = ListHealthChecksVantagePointsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse> onSuccess = new SuccessConsumer<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListHealthChecksVantagePointsRequest> onError = new ErrorConsumer<ListHealthChecksVantagePointsRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListHealthChecksVantagePointsRequest> onError = handler == null ? null : new ErrorConsumer<ListHealthChecksVantagePointsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListHealthChecksVantagePointsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListHealthChecksVantagePointsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListHttpMonitorsResponse> listHttpMonitors(ListHttpMonitorsRequest request, AsyncHandler<ListHttpMonitorsRequest, ListHttpMonitorsResponse> handler) {
        LOG.trace("Called async listHttpMonitors");
        final ListHttpMonitorsRequest interceptedRequest = ListHttpMonitorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListHttpMonitorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListHttpMonitorsResponse> transformer = ListHttpMonitorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListHttpMonitorsRequest, ListHttpMonitorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListHttpMonitorsRequest, ListHttpMonitorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListHttpMonitorsRequest, ListHttpMonitorsResponse> onSuccess = new SuccessConsumer<ListHttpMonitorsRequest, ListHttpMonitorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListHttpMonitorsRequest> onError = new ErrorConsumer<ListHttpMonitorsRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListHttpMonitorsRequest, ListHttpMonitorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListHttpMonitorsRequest, ListHttpMonitorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListHttpMonitorsRequest> onError = handler == null ? null : new ErrorConsumer<ListHttpMonitorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListHttpMonitorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListHttpMonitorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListHttpProbeResultsResponse> listHttpProbeResults(ListHttpProbeResultsRequest request, AsyncHandler<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse> handler) {
        LOG.trace("Called async listHttpProbeResults");
        final ListHttpProbeResultsRequest interceptedRequest = ListHttpProbeResultsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListHttpProbeResultsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListHttpProbeResultsResponse> transformer = ListHttpProbeResultsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse> onSuccess = new SuccessConsumer<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListHttpProbeResultsRequest> onError = new ErrorConsumer<ListHttpProbeResultsRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListHttpProbeResultsRequest> onError = handler == null ? null : new ErrorConsumer<ListHttpProbeResultsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListHttpProbeResultsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListHttpProbeResultsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPingMonitorsResponse> listPingMonitors(ListPingMonitorsRequest request, AsyncHandler<ListPingMonitorsRequest, ListPingMonitorsResponse> handler) {
        LOG.trace("Called async listPingMonitors");
        final ListPingMonitorsRequest interceptedRequest = ListPingMonitorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPingMonitorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPingMonitorsResponse> transformer = ListPingMonitorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPingMonitorsRequest, ListPingMonitorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPingMonitorsRequest, ListPingMonitorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPingMonitorsRequest, ListPingMonitorsResponse> onSuccess = new SuccessConsumer<ListPingMonitorsRequest, ListPingMonitorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPingMonitorsRequest> onError = new ErrorConsumer<ListPingMonitorsRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPingMonitorsRequest, ListPingMonitorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPingMonitorsRequest, ListPingMonitorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPingMonitorsRequest> onError = handler == null ? null : new ErrorConsumer<ListPingMonitorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPingMonitorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPingMonitorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPingProbeResultsResponse> listPingProbeResults(ListPingProbeResultsRequest request, AsyncHandler<ListPingProbeResultsRequest, ListPingProbeResultsResponse> handler) {
        LOG.trace("Called async listPingProbeResults");
        final ListPingProbeResultsRequest interceptedRequest = ListPingProbeResultsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPingProbeResultsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPingProbeResultsResponse> transformer = ListPingProbeResultsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPingProbeResultsRequest, ListPingProbeResultsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPingProbeResultsRequest, ListPingProbeResultsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPingProbeResultsRequest, ListPingProbeResultsResponse> onSuccess = new SuccessConsumer<ListPingProbeResultsRequest, ListPingProbeResultsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPingProbeResultsRequest> onError = new ErrorConsumer<ListPingProbeResultsRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPingProbeResultsRequest, ListPingProbeResultsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPingProbeResultsRequest, ListPingProbeResultsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPingProbeResultsRequest> onError = handler == null ? null : new ErrorConsumer<ListPingProbeResultsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPingProbeResultsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPingProbeResultsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateHttpMonitorResponse> updateHttpMonitor(UpdateHttpMonitorRequest request, AsyncHandler<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse> handler) {
        LOG.trace("Called async updateHttpMonitor");
        final UpdateHttpMonitorRequest interceptedRequest = UpdateHttpMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateHttpMonitorResponse> transformer = UpdateHttpMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse> onSuccess = new SuccessConsumer<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateHttpMonitorRequest> onError = new ErrorConsumer<UpdateHttpMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.put(ib, interceptedRequest.getUpdateHttpMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateHttpMonitorRequest> onError = handler == null ? null : new ErrorConsumer<UpdateHttpMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateHttpMonitorDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateHttpMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.put(ib, interceptedRequest.getUpdateHttpMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateHttpMonitorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdatePingMonitorResponse> updatePingMonitor(UpdatePingMonitorRequest request, AsyncHandler<UpdatePingMonitorRequest, UpdatePingMonitorResponse> handler) {
        LOG.trace("Called async updatePingMonitor");
        final UpdatePingMonitorRequest interceptedRequest = UpdatePingMonitorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdatePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdatePingMonitorResponse> transformer = UpdatePingMonitorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdatePingMonitorRequest, UpdatePingMonitorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdatePingMonitorRequest, UpdatePingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdatePingMonitorRequest, UpdatePingMonitorResponse> onSuccess = new SuccessConsumer<UpdatePingMonitorRequest, UpdatePingMonitorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdatePingMonitorRequest> onError = new ErrorConsumer<UpdatePingMonitorRequest>(this, interceptedRequest);
                    HealthChecksAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePingMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdatePingMonitorRequest, UpdatePingMonitorResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdatePingMonitorRequest, UpdatePingMonitorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdatePingMonitorRequest> onError = handler == null ? null : new ErrorConsumer<UpdatePingMonitorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdatePingMonitorDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdatePingMonitorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return HealthChecksAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePingMonitorDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdatePingMonitorResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, HealthChecksAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public HealthChecksAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new HealthChecksAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

