/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.healthchecks.HealthChecks;
import com.oracle.bmc.healthchecks.HealthChecksPaginators;
import com.oracle.bmc.healthchecks.internal.http.ChangeHttpMonitorCompartmentConverter;
import com.oracle.bmc.healthchecks.internal.http.ChangePingMonitorCompartmentConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateOnDemandHttpProbeConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateOnDemandPingProbeConverter;
import com.oracle.bmc.healthchecks.internal.http.CreatePingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.DeleteHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.DeletePingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.GetHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.GetPingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHealthChecksVantagePointsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHttpMonitorsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHttpProbeResultsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListPingMonitorsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListPingProbeResultsConverter;
import com.oracle.bmc.healthchecks.internal.http.UpdateHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.UpdatePingMonitorConverter;
import com.oracle.bmc.healthchecks.requests.ChangeHttpMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.ChangePingMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.CreateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandHttpProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandPingProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreatePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeleteHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeletePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetPingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.ListHealthChecksVantagePointsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.UpdateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.UpdatePingMonitorRequest;
import com.oracle.bmc.healthchecks.responses.ChangeHttpMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.ChangePingMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.CreateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandHttpProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandPingProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreatePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeleteHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeletePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetPingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.ListHealthChecksVantagePointsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.UpdateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecksClient
implements HealthChecks {
    private static final Logger LOG = LoggerFactory.getLogger(HealthChecksClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("HEALTHCHECKS").serviceEndpointPrefix("healthchecks").serviceEndpointTemplate("https://healthchecks.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final HealthChecksPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public HealthChecksClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public HealthChecksClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public HealthChecksClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        this.paginators = new HealthChecksPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeHttpMonitorCompartmentResponse changeHttpMonitorCompartment(ChangeHttpMonitorCompartmentRequest request) {
        LOG.trace("Called changeHttpMonitorCompartment");
        ChangeHttpMonitorCompartmentRequest interceptedRequest = ChangeHttpMonitorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeHttpMonitorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeHttpMonitorCompartmentResponse> transformer = ChangeHttpMonitorCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeHttpMonitorCompartmentDetails(), retriedRequest);
                return (ChangeHttpMonitorCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangePingMonitorCompartmentResponse changePingMonitorCompartment(ChangePingMonitorCompartmentRequest request) {
        LOG.trace("Called changePingMonitorCompartment");
        ChangePingMonitorCompartmentRequest interceptedRequest = ChangePingMonitorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePingMonitorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePingMonitorCompartmentResponse> transformer = ChangePingMonitorCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangePingMonitorCompartmentDetails(), retriedRequest);
                return (ChangePingMonitorCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateHttpMonitorResponse createHttpMonitor(CreateHttpMonitorRequest request) {
        LOG.trace("Called createHttpMonitor");
        CreateHttpMonitorRequest interceptedRequest = CreateHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateHttpMonitorResponse> transformer = CreateHttpMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateHttpMonitorDetails(), retriedRequest);
                return (CreateHttpMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOnDemandHttpProbeResponse createOnDemandHttpProbe(CreateOnDemandHttpProbeRequest request) {
        LOG.trace("Called createOnDemandHttpProbe");
        CreateOnDemandHttpProbeRequest interceptedRequest = CreateOnDemandHttpProbeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOnDemandHttpProbeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOnDemandHttpProbeResponse> transformer = CreateOnDemandHttpProbeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateOnDemandHttpProbeDetails(), retriedRequest);
                return (CreateOnDemandHttpProbeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOnDemandPingProbeResponse createOnDemandPingProbe(CreateOnDemandPingProbeRequest request) {
        LOG.trace("Called createOnDemandPingProbe");
        CreateOnDemandPingProbeRequest interceptedRequest = CreateOnDemandPingProbeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOnDemandPingProbeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOnDemandPingProbeResponse> transformer = CreateOnDemandPingProbeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateOnDemandPingProbeDetails(), retriedRequest);
                return (CreateOnDemandPingProbeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePingMonitorResponse createPingMonitor(CreatePingMonitorRequest request) {
        LOG.trace("Called createPingMonitor");
        CreatePingMonitorRequest interceptedRequest = CreatePingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePingMonitorResponse> transformer = CreatePingMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreatePingMonitorDetails(), retriedRequest);
                return (CreatePingMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteHttpMonitorResponse deleteHttpMonitor(DeleteHttpMonitorRequest request) {
        LOG.trace("Called deleteHttpMonitor");
        DeleteHttpMonitorRequest interceptedRequest = DeleteHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteHttpMonitorResponse> transformer = DeleteHttpMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteHttpMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePingMonitorResponse deletePingMonitor(DeletePingMonitorRequest request) {
        LOG.trace("Called deletePingMonitor");
        DeletePingMonitorRequest interceptedRequest = DeletePingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePingMonitorResponse> transformer = DeletePingMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeletePingMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHttpMonitorResponse getHttpMonitor(GetHttpMonitorRequest request) {
        LOG.trace("Called getHttpMonitor");
        GetHttpMonitorRequest interceptedRequest = GetHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHttpMonitorResponse> transformer = GetHttpMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetHttpMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPingMonitorResponse getPingMonitor(GetPingMonitorRequest request) {
        LOG.trace("Called getPingMonitor");
        GetPingMonitorRequest interceptedRequest = GetPingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPingMonitorResponse> transformer = GetPingMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetPingMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListHealthChecksVantagePointsResponse listHealthChecksVantagePoints(ListHealthChecksVantagePointsRequest request) {
        LOG.trace("Called listHealthChecksVantagePoints");
        ListHealthChecksVantagePointsRequest interceptedRequest = ListHealthChecksVantagePointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHealthChecksVantagePointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHealthChecksVantagePointsResponse> transformer = ListHealthChecksVantagePointsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListHealthChecksVantagePointsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListHttpMonitorsResponse listHttpMonitors(ListHttpMonitorsRequest request) {
        LOG.trace("Called listHttpMonitors");
        ListHttpMonitorsRequest interceptedRequest = ListHttpMonitorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHttpMonitorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHttpMonitorsResponse> transformer = ListHttpMonitorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListHttpMonitorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListHttpProbeResultsResponse listHttpProbeResults(ListHttpProbeResultsRequest request) {
        LOG.trace("Called listHttpProbeResults");
        ListHttpProbeResultsRequest interceptedRequest = ListHttpProbeResultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHttpProbeResultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHttpProbeResultsResponse> transformer = ListHttpProbeResultsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListHttpProbeResultsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPingMonitorsResponse listPingMonitors(ListPingMonitorsRequest request) {
        LOG.trace("Called listPingMonitors");
        ListPingMonitorsRequest interceptedRequest = ListPingMonitorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPingMonitorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPingMonitorsResponse> transformer = ListPingMonitorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListPingMonitorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPingProbeResultsResponse listPingProbeResults(ListPingProbeResultsRequest request) {
        LOG.trace("Called listPingProbeResults");
        ListPingProbeResultsRequest interceptedRequest = ListPingProbeResultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPingProbeResultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPingProbeResultsResponse> transformer = ListPingProbeResultsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListPingProbeResultsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHttpMonitorResponse updateHttpMonitor(UpdateHttpMonitorRequest request) {
        LOG.trace("Called updateHttpMonitor");
        UpdateHttpMonitorRequest interceptedRequest = UpdateHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHttpMonitorResponse> transformer = UpdateHttpMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateHttpMonitorDetails(), retriedRequest);
                return (UpdateHttpMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePingMonitorResponse updatePingMonitor(UpdatePingMonitorRequest request) {
        LOG.trace("Called updatePingMonitor");
        UpdatePingMonitorRequest interceptedRequest = UpdatePingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePingMonitorResponse> transformer = UpdatePingMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdatePingMonitorDetails(), retriedRequest);
                return (UpdatePingMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public HealthChecksPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, HealthChecksClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public HealthChecksClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new HealthChecksClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

