/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.healthchecks.requests.ChangeHttpMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.responses.ChangeHttpMonitorCompartmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeHttpMonitorCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeHttpMonitorCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeHttpMonitorCompartmentRequest interceptRequest(ChangeHttpMonitorCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeHttpMonitorCompartmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeHttpMonitorCompartmentDetails(), (String)"changeHttpMonitorCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180501").path("httpMonitors").path(HttpUtils.encodePathSegment(request.getMonitorId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeHttpMonitorCompartmentResponse> fromResponse() {
        Function<Response, ChangeHttpMonitorCompartmentResponse> transformer = new Function<Response, ChangeHttpMonitorCompartmentResponse>(){

            public ChangeHttpMonitorCompartmentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ChangeHttpMonitorCompartmentResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ChangeHttpMonitorCompartmentResponse.Builder builder = ChangeHttpMonitorCompartmentResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ChangeHttpMonitorCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

