/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.healthchecks.model.HttpMonitor;
import com.oracle.bmc.healthchecks.requests.CreateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.responses.CreateHttpMonitorResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHttpMonitorConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateHttpMonitorConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateHttpMonitorRequest interceptRequest(CreateHttpMonitorRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateHttpMonitorRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateHttpMonitorDetails(), (String)"createHttpMonitorDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180501").path("httpMonitors");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateHttpMonitorResponse> fromResponse() {
        Function<Response, CreateHttpMonitorResponse> transformer = new Function<Response, CreateHttpMonitorResponse>(){

            public CreateHttpMonitorResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                Optional<List<String>> locationHeader;
                LOG.trace("Transform function invoked for CreateHttpMonitorResponse");
                Function<Response, WithHeaders<HttpMonitor>> responseFn = RESPONSE_CONVERSION_FACTORY.create(HttpMonitor.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateHttpMonitorResponse.Builder builder = CreateHttpMonitorResponse.builder();
                builder.httpMonitor((HttpMonitor)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((locationHeader = HeaderUtils.get(headers, "location")).isPresent()) {
                    builder.location(HeaderUtils.toValue("location", (String)((List)locationHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                CreateHttpMonitorResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

