/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.healthchecks.model.HttpProbe;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandHttpProbeRequest;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandHttpProbeResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOnDemandHttpProbeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOnDemandHttpProbeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateOnDemandHttpProbeRequest interceptRequest(CreateOnDemandHttpProbeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateOnDemandHttpProbeRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateOnDemandHttpProbeDetails(), (String)"createOnDemandHttpProbeDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180501").path("httpProbeResults");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, CreateOnDemandHttpProbeResponse> fromResponse() {
        Function<Response, CreateOnDemandHttpProbeResponse> transformer = new Function<Response, CreateOnDemandHttpProbeResponse>(){

            public CreateOnDemandHttpProbeResponse apply(Response rawResponse) {
                Optional<List<String>> locationHeader;
                LOG.trace("Transform function invoked for CreateOnDemandHttpProbeResponse");
                Function<Response, WithHeaders<HttpProbe>> responseFn = RESPONSE_CONVERSION_FACTORY.create(HttpProbe.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateOnDemandHttpProbeResponse.Builder builder = CreateOnDemandHttpProbeResponse.builder();
                builder.httpProbe((HttpProbe)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((locationHeader = HeaderUtils.get(headers, "location")).isPresent()) {
                    builder.location(HeaderUtils.toValue("location", (String)((List)locationHeader.get()).get(0), String.class));
                }
                CreateOnDemandHttpProbeResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

