/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.healthchecks.model.PingProbe;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandPingProbeRequest;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandPingProbeResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOnDemandPingProbeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOnDemandPingProbeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateOnDemandPingProbeRequest interceptRequest(CreateOnDemandPingProbeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateOnDemandPingProbeRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateOnDemandPingProbeDetails(), (String)"createOnDemandPingProbeDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180501").path("pingProbeResults");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, CreateOnDemandPingProbeResponse> fromResponse() {
        Function<Response, CreateOnDemandPingProbeResponse> transformer = new Function<Response, CreateOnDemandPingProbeResponse>(){

            public CreateOnDemandPingProbeResponse apply(Response rawResponse) {
                Optional<List<String>> locationHeader;
                LOG.trace("Transform function invoked for CreateOnDemandPingProbeResponse");
                Function<Response, WithHeaders<PingProbe>> responseFn = RESPONSE_CONVERSION_FACTORY.create(PingProbe.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateOnDemandPingProbeResponse.Builder builder = CreateOnDemandPingProbeResponse.builder();
                builder.pingProbe((PingProbe)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((locationHeader = HeaderUtils.get(headers, "location")).isPresent()) {
                    builder.location(HeaderUtils.toValue("location", (String)((List)locationHeader.get()).get(0), String.class));
                }
                CreateOnDemandPingProbeResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

