/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.healthchecks.model.PingMonitor;
import com.oracle.bmc.healthchecks.requests.UpdatePingMonitorRequest;
import com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePingMonitorConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatePingMonitorConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdatePingMonitorRequest interceptRequest(UpdatePingMonitorRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdatePingMonitorRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdatePingMonitorDetails(), (String)"updatePingMonitorDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180501").path("pingMonitors").path(HttpUtils.encodePathSegment(request.getMonitorId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdatePingMonitorResponse> fromResponse() {
        Function<Response, UpdatePingMonitorResponse> transformer = new Function<Response, UpdatePingMonitorResponse>(){

            public UpdatePingMonitorResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for UpdatePingMonitorResponse");
                Function<Response, WithHeaders<PingMonitor>> responseFn = RESPONSE_CONVERSION_FACTORY.create(PingMonitor.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdatePingMonitorResponse.Builder builder = UpdatePingMonitorResponse.builder();
                builder.pingMonitor((PingMonitor)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                UpdatePingMonitorResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

