/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetHttpMonitorRequest
extends BmcRequest {
    private String monitorId;
    private String opcRequestId;
    private String ifNoneMatch;

    @ConstructorProperties(value={"monitorId", "opcRequestId", "ifNoneMatch"})
    GetHttpMonitorRequest(String monitorId, String opcRequestId, String ifNoneMatch) {
        this.monitorId = monitorId;
        this.opcRequestId = opcRequestId;
        this.ifNoneMatch = ifNoneMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder {
        private String monitorId;
        private String opcRequestId;
        private String ifNoneMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHttpMonitorRequest o) {
            this.monitorId(o.getMonitorId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHttpMonitorRequest build() {
            GetHttpMonitorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public GetHttpMonitorRequest buildWithoutInvocationCallback() {
            return new GetHttpMonitorRequest(this.monitorId, this.opcRequestId, this.ifNoneMatch);
        }

        public String toString() {
            return "GetHttpMonitorRequest.Builder(monitorId=" + this.monitorId + ", opcRequestId=" + this.opcRequestId + ", ifNoneMatch=" + this.ifNoneMatch + ")";
        }
    }
}

