/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.HttpMonitor;
import java.beans.ConstructorProperties;

public class CreateHttpMonitorResponse {
    private String opcRequestId;
    private String location;
    private String etag;
    private HttpMonitor httpMonitor;

    @ConstructorProperties(value={"opcRequestId", "location", "etag", "httpMonitor"})
    CreateHttpMonitorResponse(String opcRequestId, String location, String etag, HttpMonitor httpMonitor) {
        this.opcRequestId = opcRequestId;
        this.location = location;
        this.etag = etag;
        this.httpMonitor = httpMonitor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public HttpMonitor getHttpMonitor() {
        return this.httpMonitor;
    }

    public static class Builder {
        private String opcRequestId;
        private String location;
        private String etag;
        private HttpMonitor httpMonitor;

        public Builder copy(CreateHttpMonitorResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.httpMonitor(o.getHttpMonitor());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder httpMonitor(HttpMonitor httpMonitor) {
            this.httpMonitor = httpMonitor;
            return this;
        }

        public CreateHttpMonitorResponse build() {
            return new CreateHttpMonitorResponse(this.opcRequestId, this.location, this.etag, this.httpMonitor);
        }

        public String toString() {
            return "CreateHttpMonitorResponse.Builder(opcRequestId=" + this.opcRequestId + ", location=" + this.location + ", etag=" + this.etag + ", httpMonitor=" + this.httpMonitor + ")";
        }
    }
}

