/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.HttpProbe;
import java.beans.ConstructorProperties;

public class CreateOnDemandHttpProbeResponse {
    private String opcRequestId;
    private String location;
    private HttpProbe httpProbe;

    @ConstructorProperties(value={"opcRequestId", "location", "httpProbe"})
    CreateOnDemandHttpProbeResponse(String opcRequestId, String location, HttpProbe httpProbe) {
        this.opcRequestId = opcRequestId;
        this.location = location;
        this.httpProbe = httpProbe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public HttpProbe getHttpProbe() {
        return this.httpProbe;
    }

    public static class Builder {
        private String opcRequestId;
        private String location;
        private HttpProbe httpProbe;

        public Builder copy(CreateOnDemandHttpProbeResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.location(o.getLocation());
            this.httpProbe(o.getHttpProbe());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder httpProbe(HttpProbe httpProbe) {
            this.httpProbe = httpProbe;
            return this;
        }

        public CreateOnDemandHttpProbeResponse build() {
            return new CreateOnDemandHttpProbeResponse(this.opcRequestId, this.location, this.httpProbe);
        }

        public String toString() {
            return "CreateOnDemandHttpProbeResponse.Builder(opcRequestId=" + this.opcRequestId + ", location=" + this.location + ", httpProbe=" + this.httpProbe + ")";
        }
    }
}

