/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.PingProbe;
import java.beans.ConstructorProperties;

public class CreateOnDemandPingProbeResponse {
    private String opcRequestId;
    private String location;
    private PingProbe pingProbe;

    @ConstructorProperties(value={"opcRequestId", "location", "pingProbe"})
    CreateOnDemandPingProbeResponse(String opcRequestId, String location, PingProbe pingProbe) {
        this.opcRequestId = opcRequestId;
        this.location = location;
        this.pingProbe = pingProbe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public PingProbe getPingProbe() {
        return this.pingProbe;
    }

    public static class Builder {
        private String opcRequestId;
        private String location;
        private PingProbe pingProbe;

        public Builder copy(CreateOnDemandPingProbeResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.location(o.getLocation());
            this.pingProbe(o.getPingProbe());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder pingProbe(PingProbe pingProbe) {
            this.pingProbe = pingProbe;
            return this;
        }

        public CreateOnDemandPingProbeResponse build() {
            return new CreateOnDemandPingProbeResponse(this.opcRequestId, this.location, this.pingProbe);
        }

        public String toString() {
            return "CreateOnDemandPingProbeResponse.Builder(opcRequestId=" + this.opcRequestId + ", location=" + this.location + ", pingProbe=" + this.pingProbe + ")";
        }
    }
}

