/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.PingMonitor;
import java.beans.ConstructorProperties;

public class GetPingMonitorResponse {
    private String opcRequestId;
    private String etag;
    private PingMonitor pingMonitor;
    private boolean isNotModified;

    @ConstructorProperties(value={"opcRequestId", "etag", "pingMonitor", "isNotModified"})
    GetPingMonitorResponse(String opcRequestId, String etag, PingMonitor pingMonitor, boolean isNotModified) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.pingMonitor = pingMonitor;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public PingMonitor getPingMonitor() {
        return this.pingMonitor;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private PingMonitor pingMonitor;
        private boolean isNotModified;

        public Builder copy(GetPingMonitorResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.pingMonitor(o.getPingMonitor());
            this.isNotModified(o.isNotModified());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder pingMonitor(PingMonitor pingMonitor) {
            this.pingMonitor = pingMonitor;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public GetPingMonitorResponse build() {
            return new GetPingMonitorResponse(this.opcRequestId, this.etag, this.pingMonitor, this.isNotModified);
        }

        public String toString() {
            return "GetPingMonitorResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", pingMonitor=" + this.pingMonitor + ", isNotModified=" + this.isNotModified + ")";
        }
    }
}

