/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.HttpMonitorSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListHttpMonitorsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<HttpMonitorSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListHttpMonitorsResponse(String opcRequestId, String opcNextPage, List<HttpMonitorSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<HttpMonitorSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<HttpMonitorSummary> items;

        public Builder copy(ListHttpMonitorsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<HttpMonitorSummary> items) {
            this.items = items;
            return this;
        }

        public ListHttpMonitorsResponse build() {
            return new ListHttpMonitorsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListHttpMonitorsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

