/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.HttpProbeResultSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListHttpProbeResultsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<HttpProbeResultSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListHttpProbeResultsResponse(String opcRequestId, String opcNextPage, List<HttpProbeResultSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<HttpProbeResultSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<HttpProbeResultSummary> items;

        public Builder copy(ListHttpProbeResultsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<HttpProbeResultSummary> items) {
            this.items = items;
            return this;
        }

        public ListHttpProbeResultsResponse build() {
            return new ListHttpProbeResultsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListHttpProbeResultsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

