/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.PingProbeResultSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListPingProbeResultsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<PingProbeResultSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListPingProbeResultsResponse(String opcRequestId, String opcNextPage, List<PingProbeResultSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<PingProbeResultSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<PingProbeResultSummary> items;

        public Builder copy(ListPingProbeResultsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<PingProbeResultSummary> items) {
            this.items = items;
            return this;
        }

        public ListPingProbeResultsResponse build() {
            return new ListPingProbeResultsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListPingProbeResultsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

