/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.responses;

import com.oracle.bmc.healthchecks.model.PingMonitor;
import java.beans.ConstructorProperties;

public class UpdatePingMonitorResponse {
    private String opcRequestId;
    private String etag;
    private PingMonitor pingMonitor;

    @ConstructorProperties(value={"opcRequestId", "etag", "pingMonitor"})
    UpdatePingMonitorResponse(String opcRequestId, String etag, PingMonitor pingMonitor) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.pingMonitor = pingMonitor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public PingMonitor getPingMonitor() {
        return this.pingMonitor;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private PingMonitor pingMonitor;

        public Builder copy(UpdatePingMonitorResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.pingMonitor(o.getPingMonitor());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder pingMonitor(PingMonitor pingMonitor) {
            this.pingMonitor = pingMonitor;
            return this;
        }

        public UpdatePingMonitorResponse build() {
            return new UpdatePingMonitorResponse(this.opcRequestId, this.etag, this.pingMonitor);
        }

        public String toString() {
            return "UpdatePingMonitorResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", pingMonitor=" + this.pingMonitor + ")";
        }
    }
}

