/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigurator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

public class CompositeClientConfigurator
implements ClientConfigurator {
    private final List<ClientConfigurator> configurators;

    public CompositeClientConfigurator(List<ClientConfigurator> configurators) {
        this.configurators = new ArrayList<ClientConfigurator>(configurators);
    }

    public static CompositeClientConfigurator of(ClientConfigurator ... configurators) {
        return new CompositeClientConfigurator(Arrays.asList(configurators));
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
        for (ClientConfigurator configurator : this.configurators) {
            configurator.customizeBuilder(builder);
        }
    }

    @Override
    public void customizeClient(Client client) {
        for (ClientConfigurator configurator : this.configurators) {
            configurator.customizeClient(client);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeClientConfigurator that = (CompositeClientConfigurator)o;
        return this.configurators != null ? this.configurators.equals(that.configurators) : that.configurators == null;
    }

    public int hashCode() {
        return this.configurators != null ? this.configurators.hashCode() : 0;
    }

    public List<ClientConfigurator> getConfigurators() {
        return this.configurators;
    }
}

