/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.identity.IdentityAsync;
import com.oracle.bmc.identity.internal.http.ActivateMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.AddUserToGroupConverter;
import com.oracle.bmc.identity.internal.http.AssembleEffectiveTagSetConverter;
import com.oracle.bmc.identity.internal.http.ChangeTagNamespaceCompartmentConverter;
import com.oracle.bmc.identity.internal.http.CreateAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.CreateCompartmentConverter;
import com.oracle.bmc.identity.internal.http.CreateCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.CreateDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.CreateGroupConverter;
import com.oracle.bmc.identity.internal.http.CreateIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.CreateIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.CreateMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.CreateOrResetUIPasswordConverter;
import com.oracle.bmc.identity.internal.http.CreatePolicyConverter;
import com.oracle.bmc.identity.internal.http.CreateRegionSubscriptionConverter;
import com.oracle.bmc.identity.internal.http.CreateSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.CreateSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.CreateTagConverter;
import com.oracle.bmc.identity.internal.http.CreateTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.CreateTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.CreateUserConverter;
import com.oracle.bmc.identity.internal.http.DeleteApiKeyConverter;
import com.oracle.bmc.identity.internal.http.DeleteAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.DeleteCompartmentConverter;
import com.oracle.bmc.identity.internal.http.DeleteCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.DeleteDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.DeleteGroupConverter;
import com.oracle.bmc.identity.internal.http.DeleteIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.DeleteIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.DeleteMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.DeletePolicyConverter;
import com.oracle.bmc.identity.internal.http.DeleteSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.DeleteSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.DeleteUserConverter;
import com.oracle.bmc.identity.internal.http.GenerateTotpSeedConverter;
import com.oracle.bmc.identity.internal.http.GetAuthenticationPolicyConverter;
import com.oracle.bmc.identity.internal.http.GetCompartmentConverter;
import com.oracle.bmc.identity.internal.http.GetDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.GetGroupConverter;
import com.oracle.bmc.identity.internal.http.GetIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.GetIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.GetMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.GetPolicyConverter;
import com.oracle.bmc.identity.internal.http.GetTagConverter;
import com.oracle.bmc.identity.internal.http.GetTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.GetTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.GetTaggingWorkRequestConverter;
import com.oracle.bmc.identity.internal.http.GetTenancyConverter;
import com.oracle.bmc.identity.internal.http.GetUserConverter;
import com.oracle.bmc.identity.internal.http.GetUserGroupMembershipConverter;
import com.oracle.bmc.identity.internal.http.GetUserUIPasswordInformationConverter;
import com.oracle.bmc.identity.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.identity.internal.http.ListApiKeysConverter;
import com.oracle.bmc.identity.internal.http.ListAuthTokensConverter;
import com.oracle.bmc.identity.internal.http.ListAvailabilityDomainsConverter;
import com.oracle.bmc.identity.internal.http.ListCompartmentsConverter;
import com.oracle.bmc.identity.internal.http.ListCostTrackingTagsConverter;
import com.oracle.bmc.identity.internal.http.ListCustomerSecretKeysConverter;
import com.oracle.bmc.identity.internal.http.ListDynamicGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListFaultDomainsConverter;
import com.oracle.bmc.identity.internal.http.ListGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListIdentityProviderGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListIdentityProvidersConverter;
import com.oracle.bmc.identity.internal.http.ListIdpGroupMappingsConverter;
import com.oracle.bmc.identity.internal.http.ListMfaTotpDevicesConverter;
import com.oracle.bmc.identity.internal.http.ListPoliciesConverter;
import com.oracle.bmc.identity.internal.http.ListRegionSubscriptionsConverter;
import com.oracle.bmc.identity.internal.http.ListRegionsConverter;
import com.oracle.bmc.identity.internal.http.ListSmtpCredentialsConverter;
import com.oracle.bmc.identity.internal.http.ListSwiftPasswordsConverter;
import com.oracle.bmc.identity.internal.http.ListTagDefaultsConverter;
import com.oracle.bmc.identity.internal.http.ListTagNamespacesConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestErrorsConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestLogsConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestsConverter;
import com.oracle.bmc.identity.internal.http.ListTagsConverter;
import com.oracle.bmc.identity.internal.http.ListUserGroupMembershipsConverter;
import com.oracle.bmc.identity.internal.http.ListUsersConverter;
import com.oracle.bmc.identity.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.identity.internal.http.MoveCompartmentConverter;
import com.oracle.bmc.identity.internal.http.RemoveUserFromGroupConverter;
import com.oracle.bmc.identity.internal.http.ResetIdpScimClientConverter;
import com.oracle.bmc.identity.internal.http.UpdateAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.UpdateAuthenticationPolicyConverter;
import com.oracle.bmc.identity.internal.http.UpdateCompartmentConverter;
import com.oracle.bmc.identity.internal.http.UpdateCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.UpdateDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.UpdateGroupConverter;
import com.oracle.bmc.identity.internal.http.UpdateIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.UpdateIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.UpdatePolicyConverter;
import com.oracle.bmc.identity.internal.http.UpdateSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.UpdateSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserCapabilitiesConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserStateConverter;
import com.oracle.bmc.identity.internal.http.UploadApiKeyConverter;
import com.oracle.bmc.identity.requests.ActivateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.AddUserToGroupRequest;
import com.oracle.bmc.identity.requests.AssembleEffectiveTagSetRequest;
import com.oracle.bmc.identity.requests.ChangeTagNamespaceCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateAuthTokenRequest;
import com.oracle.bmc.identity.requests.CreateCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.CreateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.CreateGroupRequest;
import com.oracle.bmc.identity.requests.CreateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.CreateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.CreateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.CreateOrResetUIPasswordRequest;
import com.oracle.bmc.identity.requests.CreatePolicyRequest;
import com.oracle.bmc.identity.requests.CreateRegionSubscriptionRequest;
import com.oracle.bmc.identity.requests.CreateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.CreateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.CreateTagDefaultRequest;
import com.oracle.bmc.identity.requests.CreateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.CreateTagRequest;
import com.oracle.bmc.identity.requests.CreateUserRequest;
import com.oracle.bmc.identity.requests.DeleteApiKeyRequest;
import com.oracle.bmc.identity.requests.DeleteAuthTokenRequest;
import com.oracle.bmc.identity.requests.DeleteCompartmentRequest;
import com.oracle.bmc.identity.requests.DeleteCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.DeleteDynamicGroupRequest;
import com.oracle.bmc.identity.requests.DeleteGroupRequest;
import com.oracle.bmc.identity.requests.DeleteIdentityProviderRequest;
import com.oracle.bmc.identity.requests.DeleteIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.DeleteMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.DeletePolicyRequest;
import com.oracle.bmc.identity.requests.DeleteSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.DeleteSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.DeleteTagDefaultRequest;
import com.oracle.bmc.identity.requests.DeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.DeleteTagRequest;
import com.oracle.bmc.identity.requests.DeleteUserRequest;
import com.oracle.bmc.identity.requests.GenerateTotpSeedRequest;
import com.oracle.bmc.identity.requests.GetAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.GetCompartmentRequest;
import com.oracle.bmc.identity.requests.GetDynamicGroupRequest;
import com.oracle.bmc.identity.requests.GetGroupRequest;
import com.oracle.bmc.identity.requests.GetIdentityProviderRequest;
import com.oracle.bmc.identity.requests.GetIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.GetMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.GetPolicyRequest;
import com.oracle.bmc.identity.requests.GetTagDefaultRequest;
import com.oracle.bmc.identity.requests.GetTagNamespaceRequest;
import com.oracle.bmc.identity.requests.GetTagRequest;
import com.oracle.bmc.identity.requests.GetTaggingWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.requests.GetUserGroupMembershipRequest;
import com.oracle.bmc.identity.requests.GetUserRequest;
import com.oracle.bmc.identity.requests.GetUserUIPasswordInformationRequest;
import com.oracle.bmc.identity.requests.GetWorkRequestRequest;
import com.oracle.bmc.identity.requests.ListApiKeysRequest;
import com.oracle.bmc.identity.requests.ListAuthTokensRequest;
import com.oracle.bmc.identity.requests.ListAvailabilityDomainsRequest;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListCostTrackingTagsRequest;
import com.oracle.bmc.identity.requests.ListCustomerSecretKeysRequest;
import com.oracle.bmc.identity.requests.ListDynamicGroupsRequest;
import com.oracle.bmc.identity.requests.ListFaultDomainsRequest;
import com.oracle.bmc.identity.requests.ListGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProviderGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProvidersRequest;
import com.oracle.bmc.identity.requests.ListIdpGroupMappingsRequest;
import com.oracle.bmc.identity.requests.ListMfaTotpDevicesRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.ListRegionSubscriptionsRequest;
import com.oracle.bmc.identity.requests.ListRegionsRequest;
import com.oracle.bmc.identity.requests.ListSmtpCredentialsRequest;
import com.oracle.bmc.identity.requests.ListSwiftPasswordsRequest;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestErrorsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestLogsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestsRequest;
import com.oracle.bmc.identity.requests.ListTagsRequest;
import com.oracle.bmc.identity.requests.ListUserGroupMembershipsRequest;
import com.oracle.bmc.identity.requests.ListUsersRequest;
import com.oracle.bmc.identity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.identity.requests.MoveCompartmentRequest;
import com.oracle.bmc.identity.requests.RemoveUserFromGroupRequest;
import com.oracle.bmc.identity.requests.ResetIdpScimClientRequest;
import com.oracle.bmc.identity.requests.UpdateAuthTokenRequest;
import com.oracle.bmc.identity.requests.UpdateAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.UpdateCompartmentRequest;
import com.oracle.bmc.identity.requests.UpdateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.UpdateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.UpdateGroupRequest;
import com.oracle.bmc.identity.requests.UpdateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.UpdateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.UpdatePolicyRequest;
import com.oracle.bmc.identity.requests.UpdateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.UpdateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.UpdateTagDefaultRequest;
import com.oracle.bmc.identity.requests.UpdateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.UpdateTagRequest;
import com.oracle.bmc.identity.requests.UpdateUserCapabilitiesRequest;
import com.oracle.bmc.identity.requests.UpdateUserRequest;
import com.oracle.bmc.identity.requests.UpdateUserStateRequest;
import com.oracle.bmc.identity.requests.UploadApiKeyRequest;
import com.oracle.bmc.identity.responses.ActivateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.AddUserToGroupResponse;
import com.oracle.bmc.identity.responses.AssembleEffectiveTagSetResponse;
import com.oracle.bmc.identity.responses.ChangeTagNamespaceCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateAuthTokenResponse;
import com.oracle.bmc.identity.responses.CreateCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.CreateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.CreateGroupResponse;
import com.oracle.bmc.identity.responses.CreateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.CreateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.CreateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.CreateOrResetUIPasswordResponse;
import com.oracle.bmc.identity.responses.CreatePolicyResponse;
import com.oracle.bmc.identity.responses.CreateRegionSubscriptionResponse;
import com.oracle.bmc.identity.responses.CreateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.CreateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.CreateTagDefaultResponse;
import com.oracle.bmc.identity.responses.CreateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.CreateTagResponse;
import com.oracle.bmc.identity.responses.CreateUserResponse;
import com.oracle.bmc.identity.responses.DeleteApiKeyResponse;
import com.oracle.bmc.identity.responses.DeleteAuthTokenResponse;
import com.oracle.bmc.identity.responses.DeleteCompartmentResponse;
import com.oracle.bmc.identity.responses.DeleteCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.DeleteDynamicGroupResponse;
import com.oracle.bmc.identity.responses.DeleteGroupResponse;
import com.oracle.bmc.identity.responses.DeleteIdentityProviderResponse;
import com.oracle.bmc.identity.responses.DeleteIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.DeleteMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.DeletePolicyResponse;
import com.oracle.bmc.identity.responses.DeleteSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.DeleteSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.DeleteTagDefaultResponse;
import com.oracle.bmc.identity.responses.DeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.DeleteTagResponse;
import com.oracle.bmc.identity.responses.DeleteUserResponse;
import com.oracle.bmc.identity.responses.GenerateTotpSeedResponse;
import com.oracle.bmc.identity.responses.GetAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.GetCompartmentResponse;
import com.oracle.bmc.identity.responses.GetDynamicGroupResponse;
import com.oracle.bmc.identity.responses.GetGroupResponse;
import com.oracle.bmc.identity.responses.GetIdentityProviderResponse;
import com.oracle.bmc.identity.responses.GetIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.GetMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.GetPolicyResponse;
import com.oracle.bmc.identity.responses.GetTagDefaultResponse;
import com.oracle.bmc.identity.responses.GetTagNamespaceResponse;
import com.oracle.bmc.identity.responses.GetTagResponse;
import com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.identity.responses.GetUserGroupMembershipResponse;
import com.oracle.bmc.identity.responses.GetUserResponse;
import com.oracle.bmc.identity.responses.GetUserUIPasswordInformationResponse;
import com.oracle.bmc.identity.responses.GetWorkRequestResponse;
import com.oracle.bmc.identity.responses.ListApiKeysResponse;
import com.oracle.bmc.identity.responses.ListAuthTokensResponse;
import com.oracle.bmc.identity.responses.ListAvailabilityDomainsResponse;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListCostTrackingTagsResponse;
import com.oracle.bmc.identity.responses.ListCustomerSecretKeysResponse;
import com.oracle.bmc.identity.responses.ListDynamicGroupsResponse;
import com.oracle.bmc.identity.responses.ListFaultDomainsResponse;
import com.oracle.bmc.identity.responses.ListGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProviderGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProvidersResponse;
import com.oracle.bmc.identity.responses.ListIdpGroupMappingsResponse;
import com.oracle.bmc.identity.responses.ListMfaTotpDevicesResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.ListRegionSubscriptionsResponse;
import com.oracle.bmc.identity.responses.ListRegionsResponse;
import com.oracle.bmc.identity.responses.ListSmtpCredentialsResponse;
import com.oracle.bmc.identity.responses.ListSwiftPasswordsResponse;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestLogsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestsResponse;
import com.oracle.bmc.identity.responses.ListTagsResponse;
import com.oracle.bmc.identity.responses.ListUserGroupMembershipsResponse;
import com.oracle.bmc.identity.responses.ListUsersResponse;
import com.oracle.bmc.identity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.identity.responses.MoveCompartmentResponse;
import com.oracle.bmc.identity.responses.RemoveUserFromGroupResponse;
import com.oracle.bmc.identity.responses.ResetIdpScimClientResponse;
import com.oracle.bmc.identity.responses.UpdateAuthTokenResponse;
import com.oracle.bmc.identity.responses.UpdateAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.UpdateCompartmentResponse;
import com.oracle.bmc.identity.responses.UpdateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.UpdateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.UpdateGroupResponse;
import com.oracle.bmc.identity.responses.UpdateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.UpdateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.UpdatePolicyResponse;
import com.oracle.bmc.identity.responses.UpdateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.UpdateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.UpdateTagDefaultResponse;
import com.oracle.bmc.identity.responses.UpdateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.UpdateTagResponse;
import com.oracle.bmc.identity.responses.UpdateUserCapabilitiesResponse;
import com.oracle.bmc.identity.responses.UpdateUserResponse;
import com.oracle.bmc.identity.responses.UpdateUserStateResponse;
import com.oracle.bmc.identity.responses.UploadApiKeyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityAsyncClient
implements IdentityAsync {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("IDENTITY").serviceEndpointPrefix("identity").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ActivateMfaTotpDeviceResponse> activateMfaTotpDevice(ActivateMfaTotpDeviceRequest request, AsyncHandler<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async activateMfaTotpDevice");
        final ActivateMfaTotpDeviceRequest interceptedRequest = ActivateMfaTotpDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ActivateMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ActivateMfaTotpDeviceResponse> transformer = ActivateMfaTotpDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> onSuccess = new SuccessConsumer<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ActivateMfaTotpDeviceRequest> onError = new ErrorConsumer<ActivateMfaTotpDeviceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getMfaTotpToken(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ActivateMfaTotpDeviceRequest> onError = handler == null ? null : new ErrorConsumer<ActivateMfaTotpDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getMfaTotpToken(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ActivateMfaTotpDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getMfaTotpToken(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ActivateMfaTotpDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<AddUserToGroupResponse> addUserToGroup(AddUserToGroupRequest request, AsyncHandler<AddUserToGroupRequest, AddUserToGroupResponse> handler) {
        LOG.trace("Called async addUserToGroup");
        final AddUserToGroupRequest interceptedRequest = AddUserToGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AddUserToGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AddUserToGroupResponse> transformer = AddUserToGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AddUserToGroupRequest, AddUserToGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AddUserToGroupRequest, AddUserToGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AddUserToGroupRequest, AddUserToGroupResponse> onSuccess = new SuccessConsumer<AddUserToGroupRequest, AddUserToGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AddUserToGroupRequest> onError = new ErrorConsumer<AddUserToGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getAddUserToGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AddUserToGroupRequest, AddUserToGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<AddUserToGroupRequest, AddUserToGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AddUserToGroupRequest> onError = handler == null ? null : new ErrorConsumer<AddUserToGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAddUserToGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AddUserToGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getAddUserToGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AddUserToGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<AssembleEffectiveTagSetResponse> assembleEffectiveTagSet(AssembleEffectiveTagSetRequest request, AsyncHandler<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> handler) {
        LOG.trace("Called async assembleEffectiveTagSet");
        final AssembleEffectiveTagSetRequest interceptedRequest = AssembleEffectiveTagSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AssembleEffectiveTagSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AssembleEffectiveTagSetResponse> transformer = AssembleEffectiveTagSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> onSuccess = new SuccessConsumer<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AssembleEffectiveTagSetRequest> onError = new ErrorConsumer<AssembleEffectiveTagSetRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AssembleEffectiveTagSetRequest> onError = handler == null ? null : new ErrorConsumer<AssembleEffectiveTagSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AssembleEffectiveTagSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AssembleEffectiveTagSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeTagNamespaceCompartmentResponse> changeTagNamespaceCompartment(ChangeTagNamespaceCompartmentRequest request, AsyncHandler<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> handler) {
        LOG.trace("Called async changeTagNamespaceCompartment");
        final ChangeTagNamespaceCompartmentRequest interceptedRequest = ChangeTagNamespaceCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeTagNamespaceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeTagNamespaceCompartmentResponse> transformer = ChangeTagNamespaceCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> onSuccess = new SuccessConsumer<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeTagNamespaceCompartmentRequest> onError = new ErrorConsumer<ChangeTagNamespaceCompartmentRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getChangeTagNamespaceCompartmentDetail(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeTagNamespaceCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeTagNamespaceCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeTagNamespaceCompartmentDetail(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeTagNamespaceCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getChangeTagNamespaceCompartmentDetail(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeTagNamespaceCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAuthTokenResponse> createAuthToken(CreateAuthTokenRequest request, AsyncHandler<CreateAuthTokenRequest, CreateAuthTokenResponse> handler) {
        LOG.trace("Called async createAuthToken");
        final CreateAuthTokenRequest interceptedRequest = CreateAuthTokenConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAuthTokenResponse> transformer = CreateAuthTokenConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAuthTokenRequest, CreateAuthTokenResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAuthTokenRequest, CreateAuthTokenResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAuthTokenRequest, CreateAuthTokenResponse> onSuccess = new SuccessConsumer<CreateAuthTokenRequest, CreateAuthTokenResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAuthTokenRequest> onError = new ErrorConsumer<CreateAuthTokenRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateAuthTokenDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAuthTokenRequest, CreateAuthTokenResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAuthTokenRequest, CreateAuthTokenResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAuthTokenRequest> onError = handler == null ? null : new ErrorConsumer<CreateAuthTokenRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAuthTokenDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAuthTokenResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateAuthTokenDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAuthTokenResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCompartmentResponse> createCompartment(CreateCompartmentRequest request, AsyncHandler<CreateCompartmentRequest, CreateCompartmentResponse> handler) {
        LOG.trace("Called async createCompartment");
        final CreateCompartmentRequest interceptedRequest = CreateCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCompartmentResponse> transformer = CreateCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCompartmentRequest, CreateCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCompartmentRequest, CreateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCompartmentRequest, CreateCompartmentResponse> onSuccess = new SuccessConsumer<CreateCompartmentRequest, CreateCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCompartmentRequest> onError = new ErrorConsumer<CreateCompartmentRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCompartmentRequest, CreateCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCompartmentRequest, CreateCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<CreateCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCustomerSecretKeyResponse> createCustomerSecretKey(CreateCustomerSecretKeyRequest request, AsyncHandler<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> handler) {
        LOG.trace("Called async createCustomerSecretKey");
        final CreateCustomerSecretKeyRequest interceptedRequest = CreateCustomerSecretKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCustomerSecretKeyResponse> transformer = CreateCustomerSecretKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> onSuccess = new SuccessConsumer<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCustomerSecretKeyRequest> onError = new ErrorConsumer<CreateCustomerSecretKeyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateCustomerSecretKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCustomerSecretKeyRequest> onError = handler == null ? null : new ErrorConsumer<CreateCustomerSecretKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCustomerSecretKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCustomerSecretKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateCustomerSecretKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCustomerSecretKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDynamicGroupResponse> createDynamicGroup(CreateDynamicGroupRequest request, AsyncHandler<CreateDynamicGroupRequest, CreateDynamicGroupResponse> handler) {
        LOG.trace("Called async createDynamicGroup");
        final CreateDynamicGroupRequest interceptedRequest = CreateDynamicGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDynamicGroupResponse> transformer = CreateDynamicGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDynamicGroupRequest, CreateDynamicGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDynamicGroupRequest, CreateDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDynamicGroupRequest, CreateDynamicGroupResponse> onSuccess = new SuccessConsumer<CreateDynamicGroupRequest, CreateDynamicGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDynamicGroupRequest> onError = new ErrorConsumer<CreateDynamicGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateDynamicGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDynamicGroupRequest, CreateDynamicGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDynamicGroupRequest, CreateDynamicGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDynamicGroupRequest> onError = handler == null ? null : new ErrorConsumer<CreateDynamicGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDynamicGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDynamicGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateDynamicGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDynamicGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateGroupResponse> createGroup(CreateGroupRequest request, AsyncHandler<CreateGroupRequest, CreateGroupResponse> handler) {
        LOG.trace("Called async createGroup");
        final CreateGroupRequest interceptedRequest = CreateGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateGroupResponse> transformer = CreateGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateGroupRequest, CreateGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateGroupRequest, CreateGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateGroupRequest, CreateGroupResponse> onSuccess = new SuccessConsumer<CreateGroupRequest, CreateGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateGroupRequest> onError = new ErrorConsumer<CreateGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateGroupRequest, CreateGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateGroupRequest, CreateGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateGroupRequest> onError = handler == null ? null : new ErrorConsumer<CreateGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateIdentityProviderResponse> createIdentityProvider(CreateIdentityProviderRequest request, AsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResponse> handler) {
        LOG.trace("Called async createIdentityProvider");
        final CreateIdentityProviderRequest interceptedRequest = CreateIdentityProviderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateIdentityProviderResponse> transformer = CreateIdentityProviderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateIdentityProviderRequest, CreateIdentityProviderResponse> onSuccess = new SuccessConsumer<CreateIdentityProviderRequest, CreateIdentityProviderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateIdentityProviderRequest> onError = new ErrorConsumer<CreateIdentityProviderRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateIdentityProviderDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateIdentityProviderRequest, CreateIdentityProviderResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateIdentityProviderRequest, CreateIdentityProviderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateIdentityProviderRequest> onError = handler == null ? null : new ErrorConsumer<CreateIdentityProviderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateIdentityProviderDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateIdentityProviderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateIdentityProviderDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateIdentityProviderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateIdpGroupMappingResponse> createIdpGroupMapping(CreateIdpGroupMappingRequest request, AsyncHandler<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> handler) {
        LOG.trace("Called async createIdpGroupMapping");
        final CreateIdpGroupMappingRequest interceptedRequest = CreateIdpGroupMappingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateIdpGroupMappingResponse> transformer = CreateIdpGroupMappingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> onSuccess = new SuccessConsumer<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateIdpGroupMappingRequest> onError = new ErrorConsumer<CreateIdpGroupMappingRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateIdpGroupMappingDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateIdpGroupMappingRequest> onError = handler == null ? null : new ErrorConsumer<CreateIdpGroupMappingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateIdpGroupMappingDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateIdpGroupMappingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateIdpGroupMappingDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateIdpGroupMappingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateMfaTotpDeviceResponse> createMfaTotpDevice(CreateMfaTotpDeviceRequest request, AsyncHandler<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async createMfaTotpDevice");
        final CreateMfaTotpDeviceRequest interceptedRequest = CreateMfaTotpDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateMfaTotpDeviceResponse> transformer = CreateMfaTotpDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> onSuccess = new SuccessConsumer<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateMfaTotpDeviceRequest> onError = new ErrorConsumer<CreateMfaTotpDeviceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateMfaTotpDeviceRequest> onError = handler == null ? null : new ErrorConsumer<CreateMfaTotpDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateMfaTotpDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateMfaTotpDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateOrResetUIPasswordResponse> createOrResetUIPassword(CreateOrResetUIPasswordRequest request, AsyncHandler<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> handler) {
        LOG.trace("Called async createOrResetUIPassword");
        final CreateOrResetUIPasswordRequest interceptedRequest = CreateOrResetUIPasswordConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateOrResetUIPasswordConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateOrResetUIPasswordResponse> transformer = CreateOrResetUIPasswordConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> onSuccess = new SuccessConsumer<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateOrResetUIPasswordRequest> onError = new ErrorConsumer<CreateOrResetUIPasswordRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateOrResetUIPasswordRequest> onError = handler == null ? null : new ErrorConsumer<CreateOrResetUIPasswordRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateOrResetUIPasswordResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateOrResetUIPasswordResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreatePolicyResponse> createPolicy(CreatePolicyRequest request, AsyncHandler<CreatePolicyRequest, CreatePolicyResponse> handler) {
        LOG.trace("Called async createPolicy");
        final CreatePolicyRequest interceptedRequest = CreatePolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreatePolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreatePolicyResponse> transformer = CreatePolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreatePolicyRequest, CreatePolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreatePolicyRequest, CreatePolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreatePolicyRequest, CreatePolicyResponse> onSuccess = new SuccessConsumer<CreatePolicyRequest, CreatePolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreatePolicyRequest> onError = new ErrorConsumer<CreatePolicyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreatePolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreatePolicyRequest, CreatePolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreatePolicyRequest, CreatePolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreatePolicyRequest> onError = handler == null ? null : new ErrorConsumer<CreatePolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreatePolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreatePolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreatePolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreatePolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateRegionSubscriptionResponse> createRegionSubscription(CreateRegionSubscriptionRequest request, AsyncHandler<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> handler) {
        LOG.trace("Called async createRegionSubscription");
        final CreateRegionSubscriptionRequest interceptedRequest = CreateRegionSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateRegionSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateRegionSubscriptionResponse> transformer = CreateRegionSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> onSuccess = new SuccessConsumer<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateRegionSubscriptionRequest> onError = new ErrorConsumer<CreateRegionSubscriptionRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateRegionSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateRegionSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<CreateRegionSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateRegionSubscriptionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateRegionSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateRegionSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateRegionSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSmtpCredentialResponse> createSmtpCredential(CreateSmtpCredentialRequest request, AsyncHandler<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> handler) {
        LOG.trace("Called async createSmtpCredential");
        final CreateSmtpCredentialRequest interceptedRequest = CreateSmtpCredentialConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSmtpCredentialResponse> transformer = CreateSmtpCredentialConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> onSuccess = new SuccessConsumer<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSmtpCredentialRequest> onError = new ErrorConsumer<CreateSmtpCredentialRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateSmtpCredentialDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSmtpCredentialRequest> onError = handler == null ? null : new ErrorConsumer<CreateSmtpCredentialRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSmtpCredentialDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSmtpCredentialResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateSmtpCredentialDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSmtpCredentialResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSwiftPasswordResponse> createSwiftPassword(CreateSwiftPasswordRequest request, AsyncHandler<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> handler) {
        LOG.trace("Called async createSwiftPassword");
        final CreateSwiftPasswordRequest interceptedRequest = CreateSwiftPasswordConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSwiftPasswordResponse> transformer = CreateSwiftPasswordConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> onSuccess = new SuccessConsumer<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSwiftPasswordRequest> onError = new ErrorConsumer<CreateSwiftPasswordRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateSwiftPasswordDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSwiftPasswordRequest> onError = handler == null ? null : new ErrorConsumer<CreateSwiftPasswordRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSwiftPasswordDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSwiftPasswordResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateSwiftPasswordDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSwiftPasswordResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTagResponse> createTag(CreateTagRequest request, AsyncHandler<CreateTagRequest, CreateTagResponse> handler) {
        LOG.trace("Called async createTag");
        final CreateTagRequest interceptedRequest = CreateTagConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTagConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTagResponse> transformer = CreateTagConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTagRequest, CreateTagResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTagRequest, CreateTagResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTagRequest, CreateTagResponse> onSuccess = new SuccessConsumer<CreateTagRequest, CreateTagResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTagRequest> onError = new ErrorConsumer<CreateTagRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateTagDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTagRequest, CreateTagResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTagRequest, CreateTagResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTagRequest> onError = handler == null ? null : new ErrorConsumer<CreateTagRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTagDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTagResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateTagDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTagResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTagDefaultResponse> createTagDefault(CreateTagDefaultRequest request, AsyncHandler<CreateTagDefaultRequest, CreateTagDefaultResponse> handler) {
        LOG.trace("Called async createTagDefault");
        final CreateTagDefaultRequest interceptedRequest = CreateTagDefaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTagDefaultResponse> transformer = CreateTagDefaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTagDefaultRequest, CreateTagDefaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTagDefaultRequest, CreateTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTagDefaultRequest, CreateTagDefaultResponse> onSuccess = new SuccessConsumer<CreateTagDefaultRequest, CreateTagDefaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTagDefaultRequest> onError = new ErrorConsumer<CreateTagDefaultRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateTagDefaultDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTagDefaultRequest, CreateTagDefaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTagDefaultRequest, CreateTagDefaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTagDefaultRequest> onError = handler == null ? null : new ErrorConsumer<CreateTagDefaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTagDefaultDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTagDefaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateTagDefaultDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTagDefaultResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTagNamespaceResponse> createTagNamespace(CreateTagNamespaceRequest request, AsyncHandler<CreateTagNamespaceRequest, CreateTagNamespaceResponse> handler) {
        LOG.trace("Called async createTagNamespace");
        final CreateTagNamespaceRequest interceptedRequest = CreateTagNamespaceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTagNamespaceResponse> transformer = CreateTagNamespaceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTagNamespaceRequest, CreateTagNamespaceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTagNamespaceRequest, CreateTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTagNamespaceRequest, CreateTagNamespaceResponse> onSuccess = new SuccessConsumer<CreateTagNamespaceRequest, CreateTagNamespaceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTagNamespaceRequest> onError = new ErrorConsumer<CreateTagNamespaceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateTagNamespaceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTagNamespaceRequest, CreateTagNamespaceResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTagNamespaceRequest, CreateTagNamespaceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTagNamespaceRequest> onError = handler == null ? null : new ErrorConsumer<CreateTagNamespaceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTagNamespaceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTagNamespaceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateTagNamespaceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTagNamespaceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateUserResponse> createUser(CreateUserRequest request, AsyncHandler<CreateUserRequest, CreateUserResponse> handler) {
        LOG.trace("Called async createUser");
        final CreateUserRequest interceptedRequest = CreateUserConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateUserConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateUserResponse> transformer = CreateUserConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateUserRequest, CreateUserResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateUserRequest, CreateUserResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateUserRequest, CreateUserResponse> onSuccess = new SuccessConsumer<CreateUserRequest, CreateUserResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateUserRequest> onError = new ErrorConsumer<CreateUserRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateUserDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateUserRequest, CreateUserResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateUserRequest, CreateUserResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateUserRequest> onError = handler == null ? null : new ErrorConsumer<CreateUserRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateUserDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateUserResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateUserDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateUserResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest request, AsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResponse> handler) {
        LOG.trace("Called async deleteApiKey");
        final DeleteApiKeyRequest interceptedRequest = DeleteApiKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteApiKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteApiKeyResponse> transformer = DeleteApiKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteApiKeyRequest, DeleteApiKeyResponse> onSuccess = new SuccessConsumer<DeleteApiKeyRequest, DeleteApiKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteApiKeyRequest> onError = new ErrorConsumer<DeleteApiKeyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteApiKeyRequest, DeleteApiKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteApiKeyRequest, DeleteApiKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteApiKeyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteApiKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteApiKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteApiKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAuthTokenResponse> deleteAuthToken(DeleteAuthTokenRequest request, AsyncHandler<DeleteAuthTokenRequest, DeleteAuthTokenResponse> handler) {
        LOG.trace("Called async deleteAuthToken");
        final DeleteAuthTokenRequest interceptedRequest = DeleteAuthTokenConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAuthTokenResponse> transformer = DeleteAuthTokenConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAuthTokenRequest, DeleteAuthTokenResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAuthTokenRequest, DeleteAuthTokenResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAuthTokenRequest, DeleteAuthTokenResponse> onSuccess = new SuccessConsumer<DeleteAuthTokenRequest, DeleteAuthTokenResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAuthTokenRequest> onError = new ErrorConsumer<DeleteAuthTokenRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAuthTokenRequest, DeleteAuthTokenResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAuthTokenRequest, DeleteAuthTokenResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAuthTokenRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAuthTokenRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAuthTokenResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAuthTokenResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCompartmentResponse> deleteCompartment(DeleteCompartmentRequest request, AsyncHandler<DeleteCompartmentRequest, DeleteCompartmentResponse> handler) {
        LOG.trace("Called async deleteCompartment");
        final DeleteCompartmentRequest interceptedRequest = DeleteCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCompartmentResponse> transformer = DeleteCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCompartmentRequest, DeleteCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCompartmentRequest, DeleteCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCompartmentRequest, DeleteCompartmentResponse> onSuccess = new SuccessConsumer<DeleteCompartmentRequest, DeleteCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCompartmentRequest> onError = new ErrorConsumer<DeleteCompartmentRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCompartmentRequest, DeleteCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCompartmentRequest, DeleteCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCustomerSecretKeyResponse> deleteCustomerSecretKey(DeleteCustomerSecretKeyRequest request, AsyncHandler<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> handler) {
        LOG.trace("Called async deleteCustomerSecretKey");
        final DeleteCustomerSecretKeyRequest interceptedRequest = DeleteCustomerSecretKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCustomerSecretKeyResponse> transformer = DeleteCustomerSecretKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> onSuccess = new SuccessConsumer<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCustomerSecretKeyRequest> onError = new ErrorConsumer<DeleteCustomerSecretKeyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCustomerSecretKeyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCustomerSecretKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCustomerSecretKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCustomerSecretKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDynamicGroupResponse> deleteDynamicGroup(DeleteDynamicGroupRequest request, AsyncHandler<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> handler) {
        LOG.trace("Called async deleteDynamicGroup");
        final DeleteDynamicGroupRequest interceptedRequest = DeleteDynamicGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDynamicGroupResponse> transformer = DeleteDynamicGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> onSuccess = new SuccessConsumer<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDynamicGroupRequest> onError = new ErrorConsumer<DeleteDynamicGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDynamicGroupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDynamicGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDynamicGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDynamicGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteGroupResponse> deleteGroup(DeleteGroupRequest request, AsyncHandler<DeleteGroupRequest, DeleteGroupResponse> handler) {
        LOG.trace("Called async deleteGroup");
        final DeleteGroupRequest interceptedRequest = DeleteGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteGroupResponse> transformer = DeleteGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteGroupRequest, DeleteGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteGroupRequest, DeleteGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteGroupRequest, DeleteGroupResponse> onSuccess = new SuccessConsumer<DeleteGroupRequest, DeleteGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteGroupRequest> onError = new ErrorConsumer<DeleteGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteGroupRequest, DeleteGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteGroupRequest, DeleteGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteGroupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteIdentityProviderResponse> deleteIdentityProvider(DeleteIdentityProviderRequest request, AsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> handler) {
        LOG.trace("Called async deleteIdentityProvider");
        final DeleteIdentityProviderRequest interceptedRequest = DeleteIdentityProviderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteIdentityProviderResponse> transformer = DeleteIdentityProviderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> onSuccess = new SuccessConsumer<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteIdentityProviderRequest> onError = new ErrorConsumer<DeleteIdentityProviderRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteIdentityProviderRequest> onError = handler == null ? null : new ErrorConsumer<DeleteIdentityProviderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteIdentityProviderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteIdentityProviderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteIdpGroupMappingResponse> deleteIdpGroupMapping(DeleteIdpGroupMappingRequest request, AsyncHandler<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> handler) {
        LOG.trace("Called async deleteIdpGroupMapping");
        final DeleteIdpGroupMappingRequest interceptedRequest = DeleteIdpGroupMappingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteIdpGroupMappingResponse> transformer = DeleteIdpGroupMappingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> onSuccess = new SuccessConsumer<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteIdpGroupMappingRequest> onError = new ErrorConsumer<DeleteIdpGroupMappingRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteIdpGroupMappingRequest> onError = handler == null ? null : new ErrorConsumer<DeleteIdpGroupMappingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteIdpGroupMappingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteIdpGroupMappingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteMfaTotpDeviceResponse> deleteMfaTotpDevice(DeleteMfaTotpDeviceRequest request, AsyncHandler<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async deleteMfaTotpDevice");
        final DeleteMfaTotpDeviceRequest interceptedRequest = DeleteMfaTotpDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteMfaTotpDeviceResponse> transformer = DeleteMfaTotpDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> onSuccess = new SuccessConsumer<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteMfaTotpDeviceRequest> onError = new ErrorConsumer<DeleteMfaTotpDeviceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteMfaTotpDeviceRequest> onError = handler == null ? null : new ErrorConsumer<DeleteMfaTotpDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteMfaTotpDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteMfaTotpDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeletePolicyResponse> deletePolicy(DeletePolicyRequest request, AsyncHandler<DeletePolicyRequest, DeletePolicyResponse> handler) {
        LOG.trace("Called async deletePolicy");
        final DeletePolicyRequest interceptedRequest = DeletePolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeletePolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeletePolicyResponse> transformer = DeletePolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeletePolicyRequest, DeletePolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeletePolicyRequest, DeletePolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeletePolicyRequest, DeletePolicyResponse> onSuccess = new SuccessConsumer<DeletePolicyRequest, DeletePolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeletePolicyRequest> onError = new ErrorConsumer<DeletePolicyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeletePolicyRequest, DeletePolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeletePolicyRequest, DeletePolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeletePolicyRequest> onError = handler == null ? null : new ErrorConsumer<DeletePolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeletePolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeletePolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSmtpCredentialResponse> deleteSmtpCredential(DeleteSmtpCredentialRequest request, AsyncHandler<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> handler) {
        LOG.trace("Called async deleteSmtpCredential");
        final DeleteSmtpCredentialRequest interceptedRequest = DeleteSmtpCredentialConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSmtpCredentialResponse> transformer = DeleteSmtpCredentialConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> onSuccess = new SuccessConsumer<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSmtpCredentialRequest> onError = new ErrorConsumer<DeleteSmtpCredentialRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSmtpCredentialRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSmtpCredentialRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSmtpCredentialResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSmtpCredentialResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSwiftPasswordResponse> deleteSwiftPassword(DeleteSwiftPasswordRequest request, AsyncHandler<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> handler) {
        LOG.trace("Called async deleteSwiftPassword");
        final DeleteSwiftPasswordRequest interceptedRequest = DeleteSwiftPasswordConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSwiftPasswordResponse> transformer = DeleteSwiftPasswordConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> onSuccess = new SuccessConsumer<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSwiftPasswordRequest> onError = new ErrorConsumer<DeleteSwiftPasswordRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSwiftPasswordRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSwiftPasswordRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSwiftPasswordResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSwiftPasswordResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTagResponse> deleteTag(DeleteTagRequest request, AsyncHandler<DeleteTagRequest, DeleteTagResponse> handler) {
        LOG.trace("Called async deleteTag");
        final DeleteTagRequest interceptedRequest = DeleteTagConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTagConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTagResponse> transformer = DeleteTagConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTagRequest, DeleteTagResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTagRequest, DeleteTagResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTagRequest, DeleteTagResponse> onSuccess = new SuccessConsumer<DeleteTagRequest, DeleteTagResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTagRequest> onError = new ErrorConsumer<DeleteTagRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTagRequest, DeleteTagResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTagRequest, DeleteTagResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTagRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTagRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTagResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTagResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTagDefaultResponse> deleteTagDefault(DeleteTagDefaultRequest request, AsyncHandler<DeleteTagDefaultRequest, DeleteTagDefaultResponse> handler) {
        LOG.trace("Called async deleteTagDefault");
        final DeleteTagDefaultRequest interceptedRequest = DeleteTagDefaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTagDefaultResponse> transformer = DeleteTagDefaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTagDefaultRequest, DeleteTagDefaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTagDefaultRequest, DeleteTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTagDefaultRequest, DeleteTagDefaultResponse> onSuccess = new SuccessConsumer<DeleteTagDefaultRequest, DeleteTagDefaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTagDefaultRequest> onError = new ErrorConsumer<DeleteTagDefaultRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTagDefaultRequest, DeleteTagDefaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTagDefaultRequest, DeleteTagDefaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTagDefaultRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTagDefaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTagDefaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTagDefaultResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTagNamespaceResponse> deleteTagNamespace(DeleteTagNamespaceRequest request, AsyncHandler<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> handler) {
        LOG.trace("Called async deleteTagNamespace");
        final DeleteTagNamespaceRequest interceptedRequest = DeleteTagNamespaceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTagNamespaceResponse> transformer = DeleteTagNamespaceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> onSuccess = new SuccessConsumer<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTagNamespaceRequest> onError = new ErrorConsumer<DeleteTagNamespaceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTagNamespaceRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTagNamespaceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTagNamespaceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTagNamespaceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteUserResponse> deleteUser(DeleteUserRequest request, AsyncHandler<DeleteUserRequest, DeleteUserResponse> handler) {
        LOG.trace("Called async deleteUser");
        final DeleteUserRequest interceptedRequest = DeleteUserConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteUserConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteUserResponse> transformer = DeleteUserConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteUserRequest, DeleteUserResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteUserRequest, DeleteUserResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteUserRequest, DeleteUserResponse> onSuccess = new SuccessConsumer<DeleteUserRequest, DeleteUserResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteUserRequest> onError = new ErrorConsumer<DeleteUserRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteUserRequest, DeleteUserResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteUserRequest, DeleteUserResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteUserRequest> onError = handler == null ? null : new ErrorConsumer<DeleteUserRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteUserResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteUserResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GenerateTotpSeedResponse> generateTotpSeed(GenerateTotpSeedRequest request, AsyncHandler<GenerateTotpSeedRequest, GenerateTotpSeedResponse> handler) {
        LOG.trace("Called async generateTotpSeed");
        final GenerateTotpSeedRequest interceptedRequest = GenerateTotpSeedConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GenerateTotpSeedConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GenerateTotpSeedResponse> transformer = GenerateTotpSeedConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GenerateTotpSeedRequest, GenerateTotpSeedResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GenerateTotpSeedRequest, GenerateTotpSeedResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GenerateTotpSeedRequest, GenerateTotpSeedResponse> onSuccess = new SuccessConsumer<GenerateTotpSeedRequest, GenerateTotpSeedResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GenerateTotpSeedRequest> onError = new ErrorConsumer<GenerateTotpSeedRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GenerateTotpSeedRequest, GenerateTotpSeedResponse> onSuccess = handler == null ? null : new SuccessConsumer<GenerateTotpSeedRequest, GenerateTotpSeedResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GenerateTotpSeedRequest> onError = handler == null ? null : new ErrorConsumer<GenerateTotpSeedRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GenerateTotpSeedResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GenerateTotpSeedResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAuthenticationPolicyResponse> getAuthenticationPolicy(GetAuthenticationPolicyRequest request, AsyncHandler<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> handler) {
        LOG.trace("Called async getAuthenticationPolicy");
        final GetAuthenticationPolicyRequest interceptedRequest = GetAuthenticationPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAuthenticationPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAuthenticationPolicyResponse> transformer = GetAuthenticationPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> onSuccess = new SuccessConsumer<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAuthenticationPolicyRequest> onError = new ErrorConsumer<GetAuthenticationPolicyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAuthenticationPolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetAuthenticationPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAuthenticationPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAuthenticationPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCompartmentResponse> getCompartment(GetCompartmentRequest request, AsyncHandler<GetCompartmentRequest, GetCompartmentResponse> handler) {
        LOG.trace("Called async getCompartment");
        final GetCompartmentRequest interceptedRequest = GetCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCompartmentResponse> transformer = GetCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCompartmentRequest, GetCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCompartmentRequest, GetCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCompartmentRequest, GetCompartmentResponse> onSuccess = new SuccessConsumer<GetCompartmentRequest, GetCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCompartmentRequest> onError = new ErrorConsumer<GetCompartmentRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCompartmentRequest, GetCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCompartmentRequest, GetCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<GetCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDynamicGroupResponse> getDynamicGroup(GetDynamicGroupRequest request, AsyncHandler<GetDynamicGroupRequest, GetDynamicGroupResponse> handler) {
        LOG.trace("Called async getDynamicGroup");
        final GetDynamicGroupRequest interceptedRequest = GetDynamicGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDynamicGroupResponse> transformer = GetDynamicGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDynamicGroupRequest, GetDynamicGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDynamicGroupRequest, GetDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDynamicGroupRequest, GetDynamicGroupResponse> onSuccess = new SuccessConsumer<GetDynamicGroupRequest, GetDynamicGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDynamicGroupRequest> onError = new ErrorConsumer<GetDynamicGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDynamicGroupRequest, GetDynamicGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDynamicGroupRequest, GetDynamicGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDynamicGroupRequest> onError = handler == null ? null : new ErrorConsumer<GetDynamicGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDynamicGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDynamicGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetGroupResponse> getGroup(GetGroupRequest request, AsyncHandler<GetGroupRequest, GetGroupResponse> handler) {
        LOG.trace("Called async getGroup");
        final GetGroupRequest interceptedRequest = GetGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetGroupResponse> transformer = GetGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetGroupRequest, GetGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetGroupRequest, GetGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetGroupRequest, GetGroupResponse> onSuccess = new SuccessConsumer<GetGroupRequest, GetGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetGroupRequest> onError = new ErrorConsumer<GetGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetGroupRequest, GetGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetGroupRequest, GetGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetGroupRequest> onError = handler == null ? null : new ErrorConsumer<GetGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIdentityProviderResponse> getIdentityProvider(GetIdentityProviderRequest request, AsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResponse> handler) {
        LOG.trace("Called async getIdentityProvider");
        final GetIdentityProviderRequest interceptedRequest = GetIdentityProviderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIdentityProviderResponse> transformer = GetIdentityProviderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIdentityProviderRequest, GetIdentityProviderResponse> onSuccess = new SuccessConsumer<GetIdentityProviderRequest, GetIdentityProviderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIdentityProviderRequest> onError = new ErrorConsumer<GetIdentityProviderRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIdentityProviderRequest, GetIdentityProviderResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIdentityProviderRequest, GetIdentityProviderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIdentityProviderRequest> onError = handler == null ? null : new ErrorConsumer<GetIdentityProviderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIdentityProviderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIdentityProviderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIdpGroupMappingResponse> getIdpGroupMapping(GetIdpGroupMappingRequest request, AsyncHandler<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> handler) {
        LOG.trace("Called async getIdpGroupMapping");
        final GetIdpGroupMappingRequest interceptedRequest = GetIdpGroupMappingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIdpGroupMappingResponse> transformer = GetIdpGroupMappingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> onSuccess = new SuccessConsumer<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIdpGroupMappingRequest> onError = new ErrorConsumer<GetIdpGroupMappingRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIdpGroupMappingRequest> onError = handler == null ? null : new ErrorConsumer<GetIdpGroupMappingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIdpGroupMappingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIdpGroupMappingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetMfaTotpDeviceResponse> getMfaTotpDevice(GetMfaTotpDeviceRequest request, AsyncHandler<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async getMfaTotpDevice");
        final GetMfaTotpDeviceRequest interceptedRequest = GetMfaTotpDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetMfaTotpDeviceResponse> transformer = GetMfaTotpDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> onSuccess = new SuccessConsumer<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetMfaTotpDeviceRequest> onError = new ErrorConsumer<GetMfaTotpDeviceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetMfaTotpDeviceRequest> onError = handler == null ? null : new ErrorConsumer<GetMfaTotpDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetMfaTotpDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetMfaTotpDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPolicyResponse> getPolicy(GetPolicyRequest request, AsyncHandler<GetPolicyRequest, GetPolicyResponse> handler) {
        LOG.trace("Called async getPolicy");
        final GetPolicyRequest interceptedRequest = GetPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPolicyResponse> transformer = GetPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPolicyRequest, GetPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPolicyRequest, GetPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPolicyRequest, GetPolicyResponse> onSuccess = new SuccessConsumer<GetPolicyRequest, GetPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPolicyRequest> onError = new ErrorConsumer<GetPolicyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPolicyRequest, GetPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPolicyRequest, GetPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTagResponse> getTag(GetTagRequest request, AsyncHandler<GetTagRequest, GetTagResponse> handler) {
        LOG.trace("Called async getTag");
        final GetTagRequest interceptedRequest = GetTagConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTagConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTagResponse> transformer = GetTagConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTagRequest, GetTagResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTagRequest, GetTagResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTagRequest, GetTagResponse> onSuccess = new SuccessConsumer<GetTagRequest, GetTagResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTagRequest> onError = new ErrorConsumer<GetTagRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTagRequest, GetTagResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTagRequest, GetTagResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTagRequest> onError = handler == null ? null : new ErrorConsumer<GetTagRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTagResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTagResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTagDefaultResponse> getTagDefault(GetTagDefaultRequest request, AsyncHandler<GetTagDefaultRequest, GetTagDefaultResponse> handler) {
        LOG.trace("Called async getTagDefault");
        final GetTagDefaultRequest interceptedRequest = GetTagDefaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTagDefaultResponse> transformer = GetTagDefaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTagDefaultRequest, GetTagDefaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTagDefaultRequest, GetTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTagDefaultRequest, GetTagDefaultResponse> onSuccess = new SuccessConsumer<GetTagDefaultRequest, GetTagDefaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTagDefaultRequest> onError = new ErrorConsumer<GetTagDefaultRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTagDefaultRequest, GetTagDefaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTagDefaultRequest, GetTagDefaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTagDefaultRequest> onError = handler == null ? null : new ErrorConsumer<GetTagDefaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTagDefaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTagDefaultResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTagNamespaceResponse> getTagNamespace(GetTagNamespaceRequest request, AsyncHandler<GetTagNamespaceRequest, GetTagNamespaceResponse> handler) {
        LOG.trace("Called async getTagNamespace");
        final GetTagNamespaceRequest interceptedRequest = GetTagNamespaceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTagNamespaceResponse> transformer = GetTagNamespaceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTagNamespaceRequest, GetTagNamespaceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTagNamespaceRequest, GetTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTagNamespaceRequest, GetTagNamespaceResponse> onSuccess = new SuccessConsumer<GetTagNamespaceRequest, GetTagNamespaceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTagNamespaceRequest> onError = new ErrorConsumer<GetTagNamespaceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTagNamespaceRequest, GetTagNamespaceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTagNamespaceRequest, GetTagNamespaceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTagNamespaceRequest> onError = handler == null ? null : new ErrorConsumer<GetTagNamespaceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTagNamespaceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTagNamespaceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTaggingWorkRequestResponse> getTaggingWorkRequest(GetTaggingWorkRequestRequest request, AsyncHandler<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> handler) {
        LOG.trace("Called async getTaggingWorkRequest");
        final GetTaggingWorkRequestRequest interceptedRequest = GetTaggingWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTaggingWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTaggingWorkRequestResponse> transformer = GetTaggingWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> onSuccess = new SuccessConsumer<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTaggingWorkRequestRequest> onError = new ErrorConsumer<GetTaggingWorkRequestRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTaggingWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetTaggingWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTaggingWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTaggingWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTenancyResponse> getTenancy(GetTenancyRequest request, AsyncHandler<GetTenancyRequest, GetTenancyResponse> handler) {
        LOG.trace("Called async getTenancy");
        final GetTenancyRequest interceptedRequest = GetTenancyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTenancyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTenancyResponse> transformer = GetTenancyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTenancyRequest, GetTenancyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTenancyRequest, GetTenancyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTenancyRequest, GetTenancyResponse> onSuccess = new SuccessConsumer<GetTenancyRequest, GetTenancyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTenancyRequest> onError = new ErrorConsumer<GetTenancyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTenancyRequest, GetTenancyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTenancyRequest, GetTenancyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTenancyRequest> onError = handler == null ? null : new ErrorConsumer<GetTenancyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTenancyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTenancyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetUserResponse> getUser(GetUserRequest request, AsyncHandler<GetUserRequest, GetUserResponse> handler) {
        LOG.trace("Called async getUser");
        final GetUserRequest interceptedRequest = GetUserConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetUserConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetUserResponse> transformer = GetUserConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetUserRequest, GetUserResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetUserRequest, GetUserResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetUserRequest, GetUserResponse> onSuccess = new SuccessConsumer<GetUserRequest, GetUserResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetUserRequest> onError = new ErrorConsumer<GetUserRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetUserRequest, GetUserResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetUserRequest, GetUserResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetUserRequest> onError = handler == null ? null : new ErrorConsumer<GetUserRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetUserResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetUserResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetUserGroupMembershipResponse> getUserGroupMembership(GetUserGroupMembershipRequest request, AsyncHandler<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> handler) {
        LOG.trace("Called async getUserGroupMembership");
        final GetUserGroupMembershipRequest interceptedRequest = GetUserGroupMembershipConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetUserGroupMembershipConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetUserGroupMembershipResponse> transformer = GetUserGroupMembershipConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> onSuccess = new SuccessConsumer<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetUserGroupMembershipRequest> onError = new ErrorConsumer<GetUserGroupMembershipRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetUserGroupMembershipRequest> onError = handler == null ? null : new ErrorConsumer<GetUserGroupMembershipRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetUserGroupMembershipResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetUserGroupMembershipResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetUserUIPasswordInformationResponse> getUserUIPasswordInformation(GetUserUIPasswordInformationRequest request, AsyncHandler<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> handler) {
        LOG.trace("Called async getUserUIPasswordInformation");
        final GetUserUIPasswordInformationRequest interceptedRequest = GetUserUIPasswordInformationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetUserUIPasswordInformationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetUserUIPasswordInformationResponse> transformer = GetUserUIPasswordInformationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> onSuccess = new SuccessConsumer<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetUserUIPasswordInformationRequest> onError = new ErrorConsumer<GetUserUIPasswordInformationRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetUserUIPasswordInformationRequest> onError = handler == null ? null : new ErrorConsumer<GetUserUIPasswordInformationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetUserUIPasswordInformationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetUserUIPasswordInformationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListApiKeysResponse> listApiKeys(ListApiKeysRequest request, AsyncHandler<ListApiKeysRequest, ListApiKeysResponse> handler) {
        LOG.trace("Called async listApiKeys");
        final ListApiKeysRequest interceptedRequest = ListApiKeysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListApiKeysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListApiKeysResponse> transformer = ListApiKeysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListApiKeysRequest, ListApiKeysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListApiKeysRequest, ListApiKeysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListApiKeysRequest, ListApiKeysResponse> onSuccess = new SuccessConsumer<ListApiKeysRequest, ListApiKeysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListApiKeysRequest> onError = new ErrorConsumer<ListApiKeysRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListApiKeysRequest, ListApiKeysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListApiKeysRequest, ListApiKeysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListApiKeysRequest> onError = handler == null ? null : new ErrorConsumer<ListApiKeysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListApiKeysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListApiKeysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAuthTokensResponse> listAuthTokens(ListAuthTokensRequest request, AsyncHandler<ListAuthTokensRequest, ListAuthTokensResponse> handler) {
        LOG.trace("Called async listAuthTokens");
        final ListAuthTokensRequest interceptedRequest = ListAuthTokensConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAuthTokensConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAuthTokensResponse> transformer = ListAuthTokensConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAuthTokensRequest, ListAuthTokensResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAuthTokensRequest, ListAuthTokensResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAuthTokensRequest, ListAuthTokensResponse> onSuccess = new SuccessConsumer<ListAuthTokensRequest, ListAuthTokensResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAuthTokensRequest> onError = new ErrorConsumer<ListAuthTokensRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAuthTokensRequest, ListAuthTokensResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAuthTokensRequest, ListAuthTokensResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAuthTokensRequest> onError = handler == null ? null : new ErrorConsumer<ListAuthTokensRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAuthTokensResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAuthTokensResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAvailabilityDomainsResponse> listAvailabilityDomains(ListAvailabilityDomainsRequest request, AsyncHandler<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> handler) {
        LOG.trace("Called async listAvailabilityDomains");
        final ListAvailabilityDomainsRequest interceptedRequest = ListAvailabilityDomainsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAvailabilityDomainsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAvailabilityDomainsResponse> transformer = ListAvailabilityDomainsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> onSuccess = new SuccessConsumer<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAvailabilityDomainsRequest> onError = new ErrorConsumer<ListAvailabilityDomainsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAvailabilityDomainsRequest> onError = handler == null ? null : new ErrorConsumer<ListAvailabilityDomainsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAvailabilityDomainsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAvailabilityDomainsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCompartmentsResponse> listCompartments(ListCompartmentsRequest request, AsyncHandler<ListCompartmentsRequest, ListCompartmentsResponse> handler) {
        LOG.trace("Called async listCompartments");
        final ListCompartmentsRequest interceptedRequest = ListCompartmentsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCompartmentsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCompartmentsResponse> transformer = ListCompartmentsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCompartmentsRequest, ListCompartmentsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCompartmentsRequest, ListCompartmentsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCompartmentsRequest, ListCompartmentsResponse> onSuccess = new SuccessConsumer<ListCompartmentsRequest, ListCompartmentsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCompartmentsRequest> onError = new ErrorConsumer<ListCompartmentsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCompartmentsRequest, ListCompartmentsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCompartmentsRequest, ListCompartmentsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCompartmentsRequest> onError = handler == null ? null : new ErrorConsumer<ListCompartmentsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCompartmentsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCompartmentsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCostTrackingTagsResponse> listCostTrackingTags(ListCostTrackingTagsRequest request, AsyncHandler<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> handler) {
        LOG.trace("Called async listCostTrackingTags");
        final ListCostTrackingTagsRequest interceptedRequest = ListCostTrackingTagsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCostTrackingTagsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCostTrackingTagsResponse> transformer = ListCostTrackingTagsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> onSuccess = new SuccessConsumer<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCostTrackingTagsRequest> onError = new ErrorConsumer<ListCostTrackingTagsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCostTrackingTagsRequest> onError = handler == null ? null : new ErrorConsumer<ListCostTrackingTagsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCostTrackingTagsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCostTrackingTagsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCustomerSecretKeysResponse> listCustomerSecretKeys(ListCustomerSecretKeysRequest request, AsyncHandler<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> handler) {
        LOG.trace("Called async listCustomerSecretKeys");
        final ListCustomerSecretKeysRequest interceptedRequest = ListCustomerSecretKeysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCustomerSecretKeysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCustomerSecretKeysResponse> transformer = ListCustomerSecretKeysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> onSuccess = new SuccessConsumer<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCustomerSecretKeysRequest> onError = new ErrorConsumer<ListCustomerSecretKeysRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCustomerSecretKeysRequest> onError = handler == null ? null : new ErrorConsumer<ListCustomerSecretKeysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCustomerSecretKeysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCustomerSecretKeysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDynamicGroupsResponse> listDynamicGroups(ListDynamicGroupsRequest request, AsyncHandler<ListDynamicGroupsRequest, ListDynamicGroupsResponse> handler) {
        LOG.trace("Called async listDynamicGroups");
        final ListDynamicGroupsRequest interceptedRequest = ListDynamicGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDynamicGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDynamicGroupsResponse> transformer = ListDynamicGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDynamicGroupsRequest, ListDynamicGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDynamicGroupsRequest, ListDynamicGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDynamicGroupsRequest, ListDynamicGroupsResponse> onSuccess = new SuccessConsumer<ListDynamicGroupsRequest, ListDynamicGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDynamicGroupsRequest> onError = new ErrorConsumer<ListDynamicGroupsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDynamicGroupsRequest, ListDynamicGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDynamicGroupsRequest, ListDynamicGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDynamicGroupsRequest> onError = handler == null ? null : new ErrorConsumer<ListDynamicGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDynamicGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDynamicGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListFaultDomainsResponse> listFaultDomains(ListFaultDomainsRequest request, AsyncHandler<ListFaultDomainsRequest, ListFaultDomainsResponse> handler) {
        LOG.trace("Called async listFaultDomains");
        final ListFaultDomainsRequest interceptedRequest = ListFaultDomainsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListFaultDomainsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListFaultDomainsResponse> transformer = ListFaultDomainsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListFaultDomainsRequest, ListFaultDomainsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListFaultDomainsRequest, ListFaultDomainsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListFaultDomainsRequest, ListFaultDomainsResponse> onSuccess = new SuccessConsumer<ListFaultDomainsRequest, ListFaultDomainsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListFaultDomainsRequest> onError = new ErrorConsumer<ListFaultDomainsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListFaultDomainsRequest, ListFaultDomainsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListFaultDomainsRequest, ListFaultDomainsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListFaultDomainsRequest> onError = handler == null ? null : new ErrorConsumer<ListFaultDomainsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListFaultDomainsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListFaultDomainsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListGroupsResponse> listGroups(ListGroupsRequest request, AsyncHandler<ListGroupsRequest, ListGroupsResponse> handler) {
        LOG.trace("Called async listGroups");
        final ListGroupsRequest interceptedRequest = ListGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListGroupsResponse> transformer = ListGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListGroupsRequest, ListGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListGroupsRequest, ListGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListGroupsRequest, ListGroupsResponse> onSuccess = new SuccessConsumer<ListGroupsRequest, ListGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListGroupsRequest> onError = new ErrorConsumer<ListGroupsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListGroupsRequest, ListGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListGroupsRequest, ListGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListGroupsRequest> onError = handler == null ? null : new ErrorConsumer<ListGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListIdentityProviderGroupsResponse> listIdentityProviderGroups(ListIdentityProviderGroupsRequest request, AsyncHandler<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> handler) {
        LOG.trace("Called async listIdentityProviderGroups");
        final ListIdentityProviderGroupsRequest interceptedRequest = ListIdentityProviderGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListIdentityProviderGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListIdentityProviderGroupsResponse> transformer = ListIdentityProviderGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> onSuccess = new SuccessConsumer<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListIdentityProviderGroupsRequest> onError = new ErrorConsumer<ListIdentityProviderGroupsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListIdentityProviderGroupsRequest> onError = handler == null ? null : new ErrorConsumer<ListIdentityProviderGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListIdentityProviderGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListIdentityProviderGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListIdentityProvidersResponse> listIdentityProviders(ListIdentityProvidersRequest request, AsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResponse> handler) {
        LOG.trace("Called async listIdentityProviders");
        final ListIdentityProvidersRequest interceptedRequest = ListIdentityProvidersConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListIdentityProvidersConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListIdentityProvidersResponse> transformer = ListIdentityProvidersConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListIdentityProvidersRequest, ListIdentityProvidersResponse> onSuccess = new SuccessConsumer<ListIdentityProvidersRequest, ListIdentityProvidersResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListIdentityProvidersRequest> onError = new ErrorConsumer<ListIdentityProvidersRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListIdentityProvidersRequest, ListIdentityProvidersResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListIdentityProvidersRequest, ListIdentityProvidersResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListIdentityProvidersRequest> onError = handler == null ? null : new ErrorConsumer<ListIdentityProvidersRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListIdentityProvidersResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListIdentityProvidersResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListIdpGroupMappingsResponse> listIdpGroupMappings(ListIdpGroupMappingsRequest request, AsyncHandler<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> handler) {
        LOG.trace("Called async listIdpGroupMappings");
        final ListIdpGroupMappingsRequest interceptedRequest = ListIdpGroupMappingsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListIdpGroupMappingsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListIdpGroupMappingsResponse> transformer = ListIdpGroupMappingsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> onSuccess = new SuccessConsumer<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListIdpGroupMappingsRequest> onError = new ErrorConsumer<ListIdpGroupMappingsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListIdpGroupMappingsRequest> onError = handler == null ? null : new ErrorConsumer<ListIdpGroupMappingsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListIdpGroupMappingsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListIdpGroupMappingsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListMfaTotpDevicesResponse> listMfaTotpDevices(ListMfaTotpDevicesRequest request, AsyncHandler<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> handler) {
        LOG.trace("Called async listMfaTotpDevices");
        final ListMfaTotpDevicesRequest interceptedRequest = ListMfaTotpDevicesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListMfaTotpDevicesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListMfaTotpDevicesResponse> transformer = ListMfaTotpDevicesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> onSuccess = new SuccessConsumer<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListMfaTotpDevicesRequest> onError = new ErrorConsumer<ListMfaTotpDevicesRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListMfaTotpDevicesRequest> onError = handler == null ? null : new ErrorConsumer<ListMfaTotpDevicesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListMfaTotpDevicesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListMfaTotpDevicesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPoliciesResponse> listPolicies(ListPoliciesRequest request, AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handler) {
        LOG.trace("Called async listPolicies");
        final ListPoliciesRequest interceptedRequest = ListPoliciesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPoliciesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPoliciesResponse> transformer = ListPoliciesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPoliciesRequest, ListPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse> onSuccess = new SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPoliciesRequest> onError = new ErrorConsumer<ListPoliciesRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPoliciesRequest> onError = handler == null ? null : new ErrorConsumer<ListPoliciesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPoliciesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPoliciesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRegionSubscriptionsResponse> listRegionSubscriptions(ListRegionSubscriptionsRequest request, AsyncHandler<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> handler) {
        LOG.trace("Called async listRegionSubscriptions");
        final ListRegionSubscriptionsRequest interceptedRequest = ListRegionSubscriptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRegionSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRegionSubscriptionsResponse> transformer = ListRegionSubscriptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> onSuccess = new SuccessConsumer<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRegionSubscriptionsRequest> onError = new ErrorConsumer<ListRegionSubscriptionsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRegionSubscriptionsRequest> onError = handler == null ? null : new ErrorConsumer<ListRegionSubscriptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRegionSubscriptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRegionSubscriptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRegionsResponse> listRegions(ListRegionsRequest request, AsyncHandler<ListRegionsRequest, ListRegionsResponse> handler) {
        LOG.trace("Called async listRegions");
        final ListRegionsRequest interceptedRequest = ListRegionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRegionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRegionsResponse> transformer = ListRegionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRegionsRequest, ListRegionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRegionsRequest, ListRegionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRegionsRequest, ListRegionsResponse> onSuccess = new SuccessConsumer<ListRegionsRequest, ListRegionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRegionsRequest> onError = new ErrorConsumer<ListRegionsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRegionsRequest, ListRegionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRegionsRequest, ListRegionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRegionsRequest> onError = handler == null ? null : new ErrorConsumer<ListRegionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRegionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRegionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSmtpCredentialsResponse> listSmtpCredentials(ListSmtpCredentialsRequest request, AsyncHandler<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> handler) {
        LOG.trace("Called async listSmtpCredentials");
        final ListSmtpCredentialsRequest interceptedRequest = ListSmtpCredentialsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSmtpCredentialsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSmtpCredentialsResponse> transformer = ListSmtpCredentialsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> onSuccess = new SuccessConsumer<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSmtpCredentialsRequest> onError = new ErrorConsumer<ListSmtpCredentialsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSmtpCredentialsRequest> onError = handler == null ? null : new ErrorConsumer<ListSmtpCredentialsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSmtpCredentialsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSmtpCredentialsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSwiftPasswordsResponse> listSwiftPasswords(ListSwiftPasswordsRequest request, AsyncHandler<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> handler) {
        LOG.trace("Called async listSwiftPasswords");
        final ListSwiftPasswordsRequest interceptedRequest = ListSwiftPasswordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSwiftPasswordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSwiftPasswordsResponse> transformer = ListSwiftPasswordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> onSuccess = new SuccessConsumer<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSwiftPasswordsRequest> onError = new ErrorConsumer<ListSwiftPasswordsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSwiftPasswordsRequest> onError = handler == null ? null : new ErrorConsumer<ListSwiftPasswordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSwiftPasswordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSwiftPasswordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTagDefaultsResponse> listTagDefaults(ListTagDefaultsRequest request, AsyncHandler<ListTagDefaultsRequest, ListTagDefaultsResponse> handler) {
        LOG.trace("Called async listTagDefaults");
        final ListTagDefaultsRequest interceptedRequest = ListTagDefaultsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTagDefaultsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTagDefaultsResponse> transformer = ListTagDefaultsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTagDefaultsRequest, ListTagDefaultsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTagDefaultsRequest, ListTagDefaultsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTagDefaultsRequest, ListTagDefaultsResponse> onSuccess = new SuccessConsumer<ListTagDefaultsRequest, ListTagDefaultsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTagDefaultsRequest> onError = new ErrorConsumer<ListTagDefaultsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTagDefaultsRequest, ListTagDefaultsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTagDefaultsRequest, ListTagDefaultsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTagDefaultsRequest> onError = handler == null ? null : new ErrorConsumer<ListTagDefaultsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTagDefaultsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTagDefaultsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTagNamespacesResponse> listTagNamespaces(ListTagNamespacesRequest request, AsyncHandler<ListTagNamespacesRequest, ListTagNamespacesResponse> handler) {
        LOG.trace("Called async listTagNamespaces");
        final ListTagNamespacesRequest interceptedRequest = ListTagNamespacesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTagNamespacesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTagNamespacesResponse> transformer = ListTagNamespacesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTagNamespacesRequest, ListTagNamespacesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTagNamespacesRequest, ListTagNamespacesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTagNamespacesRequest, ListTagNamespacesResponse> onSuccess = new SuccessConsumer<ListTagNamespacesRequest, ListTagNamespacesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTagNamespacesRequest> onError = new ErrorConsumer<ListTagNamespacesRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTagNamespacesRequest, ListTagNamespacesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTagNamespacesRequest, ListTagNamespacesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTagNamespacesRequest> onError = handler == null ? null : new ErrorConsumer<ListTagNamespacesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTagNamespacesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTagNamespacesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTaggingWorkRequestErrorsResponse> listTaggingWorkRequestErrors(ListTaggingWorkRequestErrorsRequest request, AsyncHandler<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listTaggingWorkRequestErrors");
        final ListTaggingWorkRequestErrorsRequest interceptedRequest = ListTaggingWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTaggingWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTaggingWorkRequestErrorsResponse> transformer = ListTaggingWorkRequestErrorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> onSuccess = new SuccessConsumer<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTaggingWorkRequestErrorsRequest> onError = new ErrorConsumer<ListTaggingWorkRequestErrorsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTaggingWorkRequestErrorsRequest> onError = handler == null ? null : new ErrorConsumer<ListTaggingWorkRequestErrorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTaggingWorkRequestErrorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTaggingWorkRequestErrorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTaggingWorkRequestLogsResponse> listTaggingWorkRequestLogs(ListTaggingWorkRequestLogsRequest request, AsyncHandler<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listTaggingWorkRequestLogs");
        final ListTaggingWorkRequestLogsRequest interceptedRequest = ListTaggingWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTaggingWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTaggingWorkRequestLogsResponse> transformer = ListTaggingWorkRequestLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> onSuccess = new SuccessConsumer<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTaggingWorkRequestLogsRequest> onError = new ErrorConsumer<ListTaggingWorkRequestLogsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTaggingWorkRequestLogsRequest> onError = handler == null ? null : new ErrorConsumer<ListTaggingWorkRequestLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTaggingWorkRequestLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTaggingWorkRequestLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTaggingWorkRequestsResponse> listTaggingWorkRequests(ListTaggingWorkRequestsRequest request, AsyncHandler<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> handler) {
        LOG.trace("Called async listTaggingWorkRequests");
        final ListTaggingWorkRequestsRequest interceptedRequest = ListTaggingWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTaggingWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTaggingWorkRequestsResponse> transformer = ListTaggingWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> onSuccess = new SuccessConsumer<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTaggingWorkRequestsRequest> onError = new ErrorConsumer<ListTaggingWorkRequestsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTaggingWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListTaggingWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTaggingWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTaggingWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTagsResponse> listTags(ListTagsRequest request, AsyncHandler<ListTagsRequest, ListTagsResponse> handler) {
        LOG.trace("Called async listTags");
        final ListTagsRequest interceptedRequest = ListTagsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTagsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTagsResponse> transformer = ListTagsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTagsRequest, ListTagsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTagsRequest, ListTagsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTagsRequest, ListTagsResponse> onSuccess = new SuccessConsumer<ListTagsRequest, ListTagsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTagsRequest> onError = new ErrorConsumer<ListTagsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTagsRequest, ListTagsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTagsRequest, ListTagsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTagsRequest> onError = handler == null ? null : new ErrorConsumer<ListTagsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTagsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTagsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListUserGroupMembershipsResponse> listUserGroupMemberships(ListUserGroupMembershipsRequest request, AsyncHandler<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> handler) {
        LOG.trace("Called async listUserGroupMemberships");
        final ListUserGroupMembershipsRequest interceptedRequest = ListUserGroupMembershipsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListUserGroupMembershipsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListUserGroupMembershipsResponse> transformer = ListUserGroupMembershipsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> onSuccess = new SuccessConsumer<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListUserGroupMembershipsRequest> onError = new ErrorConsumer<ListUserGroupMembershipsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListUserGroupMembershipsRequest> onError = handler == null ? null : new ErrorConsumer<ListUserGroupMembershipsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListUserGroupMembershipsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListUserGroupMembershipsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListUsersResponse> listUsers(ListUsersRequest request, AsyncHandler<ListUsersRequest, ListUsersResponse> handler) {
        LOG.trace("Called async listUsers");
        final ListUsersRequest interceptedRequest = ListUsersConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListUsersConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListUsersResponse> transformer = ListUsersConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListUsersRequest, ListUsersResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListUsersRequest, ListUsersResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListUsersRequest, ListUsersResponse> onSuccess = new SuccessConsumer<ListUsersRequest, ListUsersResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListUsersRequest> onError = new ErrorConsumer<ListUsersRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListUsersRequest, ListUsersResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListUsersRequest, ListUsersResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListUsersRequest> onError = handler == null ? null : new ErrorConsumer<ListUsersRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListUsersResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListUsersResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<MoveCompartmentResponse> moveCompartment(MoveCompartmentRequest request, AsyncHandler<MoveCompartmentRequest, MoveCompartmentResponse> handler) {
        LOG.trace("Called async moveCompartment");
        final MoveCompartmentRequest interceptedRequest = MoveCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = MoveCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, MoveCompartmentResponse> transformer = MoveCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<MoveCompartmentRequest, MoveCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<MoveCompartmentRequest, MoveCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<MoveCompartmentRequest, MoveCompartmentResponse> onSuccess = new SuccessConsumer<MoveCompartmentRequest, MoveCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<MoveCompartmentRequest> onError = new ErrorConsumer<MoveCompartmentRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getMoveCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<MoveCompartmentRequest, MoveCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<MoveCompartmentRequest, MoveCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<MoveCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<MoveCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getMoveCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, MoveCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getMoveCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, MoveCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RemoveUserFromGroupResponse> removeUserFromGroup(RemoveUserFromGroupRequest request, AsyncHandler<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> handler) {
        LOG.trace("Called async removeUserFromGroup");
        final RemoveUserFromGroupRequest interceptedRequest = RemoveUserFromGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RemoveUserFromGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RemoveUserFromGroupResponse> transformer = RemoveUserFromGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> onSuccess = new SuccessConsumer<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RemoveUserFromGroupRequest> onError = new ErrorConsumer<RemoveUserFromGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RemoveUserFromGroupRequest> onError = handler == null ? null : new ErrorConsumer<RemoveUserFromGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RemoveUserFromGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RemoveUserFromGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ResetIdpScimClientResponse> resetIdpScimClient(ResetIdpScimClientRequest request, AsyncHandler<ResetIdpScimClientRequest, ResetIdpScimClientResponse> handler) {
        LOG.trace("Called async resetIdpScimClient");
        final ResetIdpScimClientRequest interceptedRequest = ResetIdpScimClientConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ResetIdpScimClientConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ResetIdpScimClientResponse> transformer = ResetIdpScimClientConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ResetIdpScimClientRequest, ResetIdpScimClientResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ResetIdpScimClientRequest, ResetIdpScimClientResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ResetIdpScimClientRequest, ResetIdpScimClientResponse> onSuccess = new SuccessConsumer<ResetIdpScimClientRequest, ResetIdpScimClientResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ResetIdpScimClientRequest> onError = new ErrorConsumer<ResetIdpScimClientRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ResetIdpScimClientRequest, ResetIdpScimClientResponse> onSuccess = handler == null ? null : new SuccessConsumer<ResetIdpScimClientRequest, ResetIdpScimClientResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ResetIdpScimClientRequest> onError = handler == null ? null : new ErrorConsumer<ResetIdpScimClientRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ResetIdpScimClientResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ResetIdpScimClientResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAuthTokenResponse> updateAuthToken(UpdateAuthTokenRequest request, AsyncHandler<UpdateAuthTokenRequest, UpdateAuthTokenResponse> handler) {
        LOG.trace("Called async updateAuthToken");
        final UpdateAuthTokenRequest interceptedRequest = UpdateAuthTokenConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAuthTokenResponse> transformer = UpdateAuthTokenConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAuthTokenRequest, UpdateAuthTokenResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAuthTokenRequest, UpdateAuthTokenResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAuthTokenRequest, UpdateAuthTokenResponse> onSuccess = new SuccessConsumer<UpdateAuthTokenRequest, UpdateAuthTokenResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAuthTokenRequest> onError = new ErrorConsumer<UpdateAuthTokenRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAuthTokenDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAuthTokenRequest, UpdateAuthTokenResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAuthTokenRequest, UpdateAuthTokenResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAuthTokenRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAuthTokenRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAuthTokenDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAuthTokenResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAuthTokenDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAuthTokenResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAuthenticationPolicyResponse> updateAuthenticationPolicy(UpdateAuthenticationPolicyRequest request, AsyncHandler<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> handler) {
        LOG.trace("Called async updateAuthenticationPolicy");
        final UpdateAuthenticationPolicyRequest interceptedRequest = UpdateAuthenticationPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAuthenticationPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAuthenticationPolicyResponse> transformer = UpdateAuthenticationPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> onSuccess = new SuccessConsumer<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAuthenticationPolicyRequest> onError = new ErrorConsumer<UpdateAuthenticationPolicyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAuthenticationPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAuthenticationPolicyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAuthenticationPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAuthenticationPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAuthenticationPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAuthenticationPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAuthenticationPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCompartmentResponse> updateCompartment(UpdateCompartmentRequest request, AsyncHandler<UpdateCompartmentRequest, UpdateCompartmentResponse> handler) {
        LOG.trace("Called async updateCompartment");
        final UpdateCompartmentRequest interceptedRequest = UpdateCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCompartmentResponse> transformer = UpdateCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCompartmentRequest, UpdateCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCompartmentRequest, UpdateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCompartmentRequest, UpdateCompartmentResponse> onSuccess = new SuccessConsumer<UpdateCompartmentRequest, UpdateCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCompartmentRequest> onError = new ErrorConsumer<UpdateCompartmentRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCompartmentRequest, UpdateCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCompartmentRequest, UpdateCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCustomerSecretKeyResponse> updateCustomerSecretKey(UpdateCustomerSecretKeyRequest request, AsyncHandler<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> handler) {
        LOG.trace("Called async updateCustomerSecretKey");
        final UpdateCustomerSecretKeyRequest interceptedRequest = UpdateCustomerSecretKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCustomerSecretKeyResponse> transformer = UpdateCustomerSecretKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> onSuccess = new SuccessConsumer<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCustomerSecretKeyRequest> onError = new ErrorConsumer<UpdateCustomerSecretKeyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCustomerSecretKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCustomerSecretKeyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCustomerSecretKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCustomerSecretKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCustomerSecretKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCustomerSecretKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCustomerSecretKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDynamicGroupResponse> updateDynamicGroup(UpdateDynamicGroupRequest request, AsyncHandler<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> handler) {
        LOG.trace("Called async updateDynamicGroup");
        final UpdateDynamicGroupRequest interceptedRequest = UpdateDynamicGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDynamicGroupResponse> transformer = UpdateDynamicGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> onSuccess = new SuccessConsumer<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDynamicGroupRequest> onError = new ErrorConsumer<UpdateDynamicGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDynamicGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDynamicGroupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDynamicGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDynamicGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDynamicGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDynamicGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDynamicGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateGroupResponse> updateGroup(UpdateGroupRequest request, AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handler) {
        LOG.trace("Called async updateGroup");
        final UpdateGroupRequest interceptedRequest = UpdateGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateGroupResponse> transformer = UpdateGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateGroupRequest, UpdateGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse> onSuccess = new SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateGroupRequest> onError = new ErrorConsumer<UpdateGroupRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateGroupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateIdentityProviderResponse> updateIdentityProvider(UpdateIdentityProviderRequest request, AsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> handler) {
        LOG.trace("Called async updateIdentityProvider");
        final UpdateIdentityProviderRequest interceptedRequest = UpdateIdentityProviderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateIdentityProviderResponse> transformer = UpdateIdentityProviderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> onSuccess = new SuccessConsumer<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateIdentityProviderRequest> onError = new ErrorConsumer<UpdateIdentityProviderRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIdentityProviderDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateIdentityProviderRequest> onError = handler == null ? null : new ErrorConsumer<UpdateIdentityProviderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateIdentityProviderDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateIdentityProviderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIdentityProviderDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateIdentityProviderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateIdpGroupMappingResponse> updateIdpGroupMapping(UpdateIdpGroupMappingRequest request, AsyncHandler<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> handler) {
        LOG.trace("Called async updateIdpGroupMapping");
        final UpdateIdpGroupMappingRequest interceptedRequest = UpdateIdpGroupMappingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateIdpGroupMappingResponse> transformer = UpdateIdpGroupMappingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> onSuccess = new SuccessConsumer<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateIdpGroupMappingRequest> onError = new ErrorConsumer<UpdateIdpGroupMappingRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIdpGroupMappingDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateIdpGroupMappingRequest> onError = handler == null ? null : new ErrorConsumer<UpdateIdpGroupMappingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateIdpGroupMappingDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateIdpGroupMappingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIdpGroupMappingDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateIdpGroupMappingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdatePolicyResponse> updatePolicy(UpdatePolicyRequest request, AsyncHandler<UpdatePolicyRequest, UpdatePolicyResponse> handler) {
        LOG.trace("Called async updatePolicy");
        final UpdatePolicyRequest interceptedRequest = UpdatePolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdatePolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdatePolicyResponse> transformer = UpdatePolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdatePolicyRequest, UpdatePolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdatePolicyRequest, UpdatePolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdatePolicyRequest, UpdatePolicyResponse> onSuccess = new SuccessConsumer<UpdatePolicyRequest, UpdatePolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdatePolicyRequest> onError = new ErrorConsumer<UpdatePolicyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdatePolicyRequest, UpdatePolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdatePolicyRequest, UpdatePolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdatePolicyRequest> onError = handler == null ? null : new ErrorConsumer<UpdatePolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdatePolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdatePolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdatePolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSmtpCredentialResponse> updateSmtpCredential(UpdateSmtpCredentialRequest request, AsyncHandler<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> handler) {
        LOG.trace("Called async updateSmtpCredential");
        final UpdateSmtpCredentialRequest interceptedRequest = UpdateSmtpCredentialConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSmtpCredentialResponse> transformer = UpdateSmtpCredentialConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> onSuccess = new SuccessConsumer<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSmtpCredentialRequest> onError = new ErrorConsumer<UpdateSmtpCredentialRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSmtpCredentialDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSmtpCredentialRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSmtpCredentialRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSmtpCredentialDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSmtpCredentialResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSmtpCredentialDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSmtpCredentialResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSwiftPasswordResponse> updateSwiftPassword(UpdateSwiftPasswordRequest request, AsyncHandler<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> handler) {
        LOG.trace("Called async updateSwiftPassword");
        final UpdateSwiftPasswordRequest interceptedRequest = UpdateSwiftPasswordConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSwiftPasswordResponse> transformer = UpdateSwiftPasswordConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> onSuccess = new SuccessConsumer<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSwiftPasswordRequest> onError = new ErrorConsumer<UpdateSwiftPasswordRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSwiftPasswordDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSwiftPasswordRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSwiftPasswordRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSwiftPasswordDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSwiftPasswordResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSwiftPasswordDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSwiftPasswordResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTagResponse> updateTag(UpdateTagRequest request, AsyncHandler<UpdateTagRequest, UpdateTagResponse> handler) {
        LOG.trace("Called async updateTag");
        final UpdateTagRequest interceptedRequest = UpdateTagConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTagConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTagResponse> transformer = UpdateTagConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTagRequest, UpdateTagResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTagRequest, UpdateTagResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTagRequest, UpdateTagResponse> onSuccess = new SuccessConsumer<UpdateTagRequest, UpdateTagResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTagRequest> onError = new ErrorConsumer<UpdateTagRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTagDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTagRequest, UpdateTagResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTagRequest, UpdateTagResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTagRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTagRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTagDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTagResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTagDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTagResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTagDefaultResponse> updateTagDefault(UpdateTagDefaultRequest request, AsyncHandler<UpdateTagDefaultRequest, UpdateTagDefaultResponse> handler) {
        LOG.trace("Called async updateTagDefault");
        final UpdateTagDefaultRequest interceptedRequest = UpdateTagDefaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTagDefaultResponse> transformer = UpdateTagDefaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTagDefaultRequest, UpdateTagDefaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTagDefaultRequest, UpdateTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTagDefaultRequest, UpdateTagDefaultResponse> onSuccess = new SuccessConsumer<UpdateTagDefaultRequest, UpdateTagDefaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTagDefaultRequest> onError = new ErrorConsumer<UpdateTagDefaultRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTagDefaultDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTagDefaultRequest, UpdateTagDefaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTagDefaultRequest, UpdateTagDefaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTagDefaultRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTagDefaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTagDefaultDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTagDefaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTagDefaultDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTagDefaultResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTagNamespaceResponse> updateTagNamespace(UpdateTagNamespaceRequest request, AsyncHandler<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> handler) {
        LOG.trace("Called async updateTagNamespace");
        final UpdateTagNamespaceRequest interceptedRequest = UpdateTagNamespaceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTagNamespaceResponse> transformer = UpdateTagNamespaceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> onSuccess = new SuccessConsumer<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTagNamespaceRequest> onError = new ErrorConsumer<UpdateTagNamespaceRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTagNamespaceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTagNamespaceRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTagNamespaceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTagNamespaceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTagNamespaceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTagNamespaceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTagNamespaceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateUserResponse> updateUser(UpdateUserRequest request, AsyncHandler<UpdateUserRequest, UpdateUserResponse> handler) {
        LOG.trace("Called async updateUser");
        final UpdateUserRequest interceptedRequest = UpdateUserConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateUserConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateUserResponse> transformer = UpdateUserConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateUserRequest, UpdateUserResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateUserRequest, UpdateUserResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateUserRequest, UpdateUserResponse> onSuccess = new SuccessConsumer<UpdateUserRequest, UpdateUserResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateUserRequest> onError = new ErrorConsumer<UpdateUserRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateUserDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateUserRequest, UpdateUserResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateUserRequest, UpdateUserResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateUserRequest> onError = handler == null ? null : new ErrorConsumer<UpdateUserRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateUserDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateUserResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateUserDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateUserResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateUserCapabilitiesResponse> updateUserCapabilities(UpdateUserCapabilitiesRequest request, AsyncHandler<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> handler) {
        LOG.trace("Called async updateUserCapabilities");
        final UpdateUserCapabilitiesRequest interceptedRequest = UpdateUserCapabilitiesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateUserCapabilitiesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateUserCapabilitiesResponse> transformer = UpdateUserCapabilitiesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> onSuccess = new SuccessConsumer<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateUserCapabilitiesRequest> onError = new ErrorConsumer<UpdateUserCapabilitiesRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateUserCapabilitiesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateUserCapabilitiesRequest> onError = handler == null ? null : new ErrorConsumer<UpdateUserCapabilitiesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateUserCapabilitiesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateUserCapabilitiesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateUserCapabilitiesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateUserCapabilitiesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateUserStateResponse> updateUserState(UpdateUserStateRequest request, AsyncHandler<UpdateUserStateRequest, UpdateUserStateResponse> handler) {
        LOG.trace("Called async updateUserState");
        final UpdateUserStateRequest interceptedRequest = UpdateUserStateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateUserStateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateUserStateResponse> transformer = UpdateUserStateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateUserStateRequest, UpdateUserStateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateUserStateRequest, UpdateUserStateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateUserStateRequest, UpdateUserStateResponse> onSuccess = new SuccessConsumer<UpdateUserStateRequest, UpdateUserStateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateUserStateRequest> onError = new ErrorConsumer<UpdateUserStateRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateStateDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateUserStateRequest, UpdateUserStateResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateUserStateRequest, UpdateUserStateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateUserStateRequest> onError = handler == null ? null : new ErrorConsumer<UpdateUserStateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateStateDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateUserStateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.put(ib, interceptedRequest.getUpdateStateDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateUserStateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UploadApiKeyResponse> uploadApiKey(UploadApiKeyRequest request, AsyncHandler<UploadApiKeyRequest, UploadApiKeyResponse> handler) {
        LOG.trace("Called async uploadApiKey");
        final UploadApiKeyRequest interceptedRequest = UploadApiKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UploadApiKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UploadApiKeyResponse> transformer = UploadApiKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UploadApiKeyRequest, UploadApiKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UploadApiKeyRequest, UploadApiKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UploadApiKeyRequest, UploadApiKeyResponse> onSuccess = new SuccessConsumer<UploadApiKeyRequest, UploadApiKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UploadApiKeyRequest> onError = new ErrorConsumer<UploadApiKeyRequest>(this, interceptedRequest);
                    IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateApiKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UploadApiKeyRequest, UploadApiKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UploadApiKeyRequest, UploadApiKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UploadApiKeyRequest> onError = handler == null ? null : new ErrorConsumer<UploadApiKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateApiKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UploadApiKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return IdentityAsyncClient.this.client.post(ib, interceptedRequest.getCreateApiKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UploadApiKeyResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IdentityAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public IdentityAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new IdentityAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

