/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.DynamicGroup;
import com.oracle.bmc.identity.model.Group;
import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.identity.model.IdentityProviderGroupSummary;
import com.oracle.bmc.identity.model.IdpGroupMapping;
import com.oracle.bmc.identity.model.MfaTotpDeviceSummary;
import com.oracle.bmc.identity.model.Policy;
import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.identity.model.TagNamespaceSummary;
import com.oracle.bmc.identity.model.TagSummary;
import com.oracle.bmc.identity.model.TaggingWorkRequestErrorSummary;
import com.oracle.bmc.identity.model.TaggingWorkRequestLogSummary;
import com.oracle.bmc.identity.model.TaggingWorkRequestSummary;
import com.oracle.bmc.identity.model.User;
import com.oracle.bmc.identity.model.UserGroupMembership;
import com.oracle.bmc.identity.model.WorkRequestSummary;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListCostTrackingTagsRequest;
import com.oracle.bmc.identity.requests.ListDynamicGroupsRequest;
import com.oracle.bmc.identity.requests.ListGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProviderGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProvidersRequest;
import com.oracle.bmc.identity.requests.ListIdpGroupMappingsRequest;
import com.oracle.bmc.identity.requests.ListMfaTotpDevicesRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestErrorsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestLogsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestsRequest;
import com.oracle.bmc.identity.requests.ListTagsRequest;
import com.oracle.bmc.identity.requests.ListUserGroupMembershipsRequest;
import com.oracle.bmc.identity.requests.ListUsersRequest;
import com.oracle.bmc.identity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListCostTrackingTagsResponse;
import com.oracle.bmc.identity.responses.ListDynamicGroupsResponse;
import com.oracle.bmc.identity.responses.ListGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProviderGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProvidersResponse;
import com.oracle.bmc.identity.responses.ListIdpGroupMappingsResponse;
import com.oracle.bmc.identity.responses.ListMfaTotpDevicesResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestLogsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestsResponse;
import com.oracle.bmc.identity.responses.ListTagsResponse;
import com.oracle.bmc.identity.responses.ListUserGroupMembershipsResponse;
import com.oracle.bmc.identity.responses.ListUsersResponse;
import com.oracle.bmc.identity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class IdentityPaginators {
    private final Identity client;

    public Iterable<ListCompartmentsResponse> listCompartmentsResponseIterator(final ListCompartmentsRequest request) {
        return new ResponseIterable<ListCompartmentsRequest.Builder, ListCompartmentsRequest, ListCompartmentsResponse>(new Supplier<ListCompartmentsRequest.Builder>(){

            public ListCompartmentsRequest.Builder get() {
                return ListCompartmentsRequest.builder().copy(request);
            }
        }, new Function<ListCompartmentsResponse, String>(){

            public String apply(ListCompartmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCompartmentsRequest.Builder>, ListCompartmentsRequest>(){

            public ListCompartmentsRequest apply(RequestBuilderAndToken<ListCompartmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCompartmentsRequest, ListCompartmentsResponse>(){

            public ListCompartmentsResponse apply(ListCompartmentsRequest request) {
                return IdentityPaginators.this.client.listCompartments(request);
            }
        });
    }

    public Iterable<Compartment> listCompartmentsRecordIterator(final ListCompartmentsRequest request) {
        return new ResponseRecordIterable<ListCompartmentsRequest.Builder, ListCompartmentsRequest, ListCompartmentsResponse, Compartment>(new Supplier<ListCompartmentsRequest.Builder>(){

            public ListCompartmentsRequest.Builder get() {
                return ListCompartmentsRequest.builder().copy(request);
            }
        }, new Function<ListCompartmentsResponse, String>(){

            public String apply(ListCompartmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCompartmentsRequest.Builder>, ListCompartmentsRequest>(){

            public ListCompartmentsRequest apply(RequestBuilderAndToken<ListCompartmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCompartmentsRequest, ListCompartmentsResponse>(){

            public ListCompartmentsResponse apply(ListCompartmentsRequest request) {
                return IdentityPaginators.this.client.listCompartments(request);
            }
        }, new Function<ListCompartmentsResponse, List<Compartment>>(){

            public List<Compartment> apply(ListCompartmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCostTrackingTagsResponse> listCostTrackingTagsResponseIterator(final ListCostTrackingTagsRequest request) {
        return new ResponseIterable<ListCostTrackingTagsRequest.Builder, ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>(new Supplier<ListCostTrackingTagsRequest.Builder>(){

            public ListCostTrackingTagsRequest.Builder get() {
                return ListCostTrackingTagsRequest.builder().copy(request);
            }
        }, new Function<ListCostTrackingTagsResponse, String>(){

            public String apply(ListCostTrackingTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCostTrackingTagsRequest.Builder>, ListCostTrackingTagsRequest>(){

            public ListCostTrackingTagsRequest apply(RequestBuilderAndToken<ListCostTrackingTagsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>(){

            public ListCostTrackingTagsResponse apply(ListCostTrackingTagsRequest request) {
                return IdentityPaginators.this.client.listCostTrackingTags(request);
            }
        });
    }

    public Iterable<Tag> listCostTrackingTagsRecordIterator(final ListCostTrackingTagsRequest request) {
        return new ResponseRecordIterable<ListCostTrackingTagsRequest.Builder, ListCostTrackingTagsRequest, ListCostTrackingTagsResponse, Tag>(new Supplier<ListCostTrackingTagsRequest.Builder>(){

            public ListCostTrackingTagsRequest.Builder get() {
                return ListCostTrackingTagsRequest.builder().copy(request);
            }
        }, new Function<ListCostTrackingTagsResponse, String>(){

            public String apply(ListCostTrackingTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCostTrackingTagsRequest.Builder>, ListCostTrackingTagsRequest>(){

            public ListCostTrackingTagsRequest apply(RequestBuilderAndToken<ListCostTrackingTagsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>(){

            public ListCostTrackingTagsResponse apply(ListCostTrackingTagsRequest request) {
                return IdentityPaginators.this.client.listCostTrackingTags(request);
            }
        }, new Function<ListCostTrackingTagsResponse, List<Tag>>(){

            public List<Tag> apply(ListCostTrackingTagsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDynamicGroupsResponse> listDynamicGroupsResponseIterator(final ListDynamicGroupsRequest request) {
        return new ResponseIterable<ListDynamicGroupsRequest.Builder, ListDynamicGroupsRequest, ListDynamicGroupsResponse>(new Supplier<ListDynamicGroupsRequest.Builder>(){

            public ListDynamicGroupsRequest.Builder get() {
                return ListDynamicGroupsRequest.builder().copy(request);
            }
        }, new Function<ListDynamicGroupsResponse, String>(){

            public String apply(ListDynamicGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDynamicGroupsRequest.Builder>, ListDynamicGroupsRequest>(){

            public ListDynamicGroupsRequest apply(RequestBuilderAndToken<ListDynamicGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDynamicGroupsRequest, ListDynamicGroupsResponse>(){

            public ListDynamicGroupsResponse apply(ListDynamicGroupsRequest request) {
                return IdentityPaginators.this.client.listDynamicGroups(request);
            }
        });
    }

    public Iterable<DynamicGroup> listDynamicGroupsRecordIterator(final ListDynamicGroupsRequest request) {
        return new ResponseRecordIterable<ListDynamicGroupsRequest.Builder, ListDynamicGroupsRequest, ListDynamicGroupsResponse, DynamicGroup>(new Supplier<ListDynamicGroupsRequest.Builder>(){

            public ListDynamicGroupsRequest.Builder get() {
                return ListDynamicGroupsRequest.builder().copy(request);
            }
        }, new Function<ListDynamicGroupsResponse, String>(){

            public String apply(ListDynamicGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDynamicGroupsRequest.Builder>, ListDynamicGroupsRequest>(){

            public ListDynamicGroupsRequest apply(RequestBuilderAndToken<ListDynamicGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDynamicGroupsRequest, ListDynamicGroupsResponse>(){

            public ListDynamicGroupsResponse apply(ListDynamicGroupsRequest request) {
                return IdentityPaginators.this.client.listDynamicGroups(request);
            }
        }, new Function<ListDynamicGroupsResponse, List<DynamicGroup>>(){

            public List<DynamicGroup> apply(ListDynamicGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListGroupsResponse> listGroupsResponseIterator(final ListGroupsRequest request) {
        return new ResponseIterable<ListGroupsRequest.Builder, ListGroupsRequest, ListGroupsResponse>(new Supplier<ListGroupsRequest.Builder>(){

            public ListGroupsRequest.Builder get() {
                return ListGroupsRequest.builder().copy(request);
            }
        }, new Function<ListGroupsResponse, String>(){

            public String apply(ListGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListGroupsRequest.Builder>, ListGroupsRequest>(){

            public ListGroupsRequest apply(RequestBuilderAndToken<ListGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListGroupsRequest, ListGroupsResponse>(){

            public ListGroupsResponse apply(ListGroupsRequest request) {
                return IdentityPaginators.this.client.listGroups(request);
            }
        });
    }

    public Iterable<Group> listGroupsRecordIterator(final ListGroupsRequest request) {
        return new ResponseRecordIterable<ListGroupsRequest.Builder, ListGroupsRequest, ListGroupsResponse, Group>(new Supplier<ListGroupsRequest.Builder>(){

            public ListGroupsRequest.Builder get() {
                return ListGroupsRequest.builder().copy(request);
            }
        }, new Function<ListGroupsResponse, String>(){

            public String apply(ListGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListGroupsRequest.Builder>, ListGroupsRequest>(){

            public ListGroupsRequest apply(RequestBuilderAndToken<ListGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListGroupsRequest, ListGroupsResponse>(){

            public ListGroupsResponse apply(ListGroupsRequest request) {
                return IdentityPaginators.this.client.listGroups(request);
            }
        }, new Function<ListGroupsResponse, List<Group>>(){

            public List<Group> apply(ListGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIdentityProviderGroupsResponse> listIdentityProviderGroupsResponseIterator(final ListIdentityProviderGroupsRequest request) {
        return new ResponseIterable<ListIdentityProviderGroupsRequest.Builder, ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(new Supplier<ListIdentityProviderGroupsRequest.Builder>(){

            public ListIdentityProviderGroupsRequest.Builder get() {
                return ListIdentityProviderGroupsRequest.builder().copy(request);
            }
        }, new Function<ListIdentityProviderGroupsResponse, String>(){

            public String apply(ListIdentityProviderGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder>, ListIdentityProviderGroupsRequest>(){

            public ListIdentityProviderGroupsRequest apply(RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(){

            public ListIdentityProviderGroupsResponse apply(ListIdentityProviderGroupsRequest request) {
                return IdentityPaginators.this.client.listIdentityProviderGroups(request);
            }
        });
    }

    public Iterable<IdentityProviderGroupSummary> listIdentityProviderGroupsRecordIterator(final ListIdentityProviderGroupsRequest request) {
        return new ResponseRecordIterable<ListIdentityProviderGroupsRequest.Builder, ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse, IdentityProviderGroupSummary>(new Supplier<ListIdentityProviderGroupsRequest.Builder>(){

            public ListIdentityProviderGroupsRequest.Builder get() {
                return ListIdentityProviderGroupsRequest.builder().copy(request);
            }
        }, new Function<ListIdentityProviderGroupsResponse, String>(){

            public String apply(ListIdentityProviderGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder>, ListIdentityProviderGroupsRequest>(){

            public ListIdentityProviderGroupsRequest apply(RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(){

            public ListIdentityProviderGroupsResponse apply(ListIdentityProviderGroupsRequest request) {
                return IdentityPaginators.this.client.listIdentityProviderGroups(request);
            }
        }, new Function<ListIdentityProviderGroupsResponse, List<IdentityProviderGroupSummary>>(){

            public List<IdentityProviderGroupSummary> apply(ListIdentityProviderGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIdentityProvidersResponse> listIdentityProvidersResponseIterator(final ListIdentityProvidersRequest request) {
        return new ResponseIterable<ListIdentityProvidersRequest.Builder, ListIdentityProvidersRequest, ListIdentityProvidersResponse>(new Supplier<ListIdentityProvidersRequest.Builder>(){

            public ListIdentityProvidersRequest.Builder get() {
                return ListIdentityProvidersRequest.builder().copy(request);
            }
        }, new Function<ListIdentityProvidersResponse, String>(){

            public String apply(ListIdentityProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIdentityProvidersRequest.Builder>, ListIdentityProvidersRequest>(){

            public ListIdentityProvidersRequest apply(RequestBuilderAndToken<ListIdentityProvidersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIdentityProvidersRequest, ListIdentityProvidersResponse>(){

            public ListIdentityProvidersResponse apply(ListIdentityProvidersRequest request) {
                return IdentityPaginators.this.client.listIdentityProviders(request);
            }
        });
    }

    public Iterable<IdentityProvider> listIdentityProvidersRecordIterator(final ListIdentityProvidersRequest request) {
        return new ResponseRecordIterable<ListIdentityProvidersRequest.Builder, ListIdentityProvidersRequest, ListIdentityProvidersResponse, IdentityProvider>(new Supplier<ListIdentityProvidersRequest.Builder>(){

            public ListIdentityProvidersRequest.Builder get() {
                return ListIdentityProvidersRequest.builder().copy(request);
            }
        }, new Function<ListIdentityProvidersResponse, String>(){

            public String apply(ListIdentityProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIdentityProvidersRequest.Builder>, ListIdentityProvidersRequest>(){

            public ListIdentityProvidersRequest apply(RequestBuilderAndToken<ListIdentityProvidersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIdentityProvidersRequest, ListIdentityProvidersResponse>(){

            public ListIdentityProvidersResponse apply(ListIdentityProvidersRequest request) {
                return IdentityPaginators.this.client.listIdentityProviders(request);
            }
        }, new Function<ListIdentityProvidersResponse, List<IdentityProvider>>(){

            public List<IdentityProvider> apply(ListIdentityProvidersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIdpGroupMappingsResponse> listIdpGroupMappingsResponseIterator(final ListIdpGroupMappingsRequest request) {
        return new ResponseIterable<ListIdpGroupMappingsRequest.Builder, ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(new Supplier<ListIdpGroupMappingsRequest.Builder>(){

            public ListIdpGroupMappingsRequest.Builder get() {
                return ListIdpGroupMappingsRequest.builder().copy(request);
            }
        }, new Function<ListIdpGroupMappingsResponse, String>(){

            public String apply(ListIdpGroupMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder>, ListIdpGroupMappingsRequest>(){

            public ListIdpGroupMappingsRequest apply(RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(){

            public ListIdpGroupMappingsResponse apply(ListIdpGroupMappingsRequest request) {
                return IdentityPaginators.this.client.listIdpGroupMappings(request);
            }
        });
    }

    public Iterable<IdpGroupMapping> listIdpGroupMappingsRecordIterator(final ListIdpGroupMappingsRequest request) {
        return new ResponseRecordIterable<ListIdpGroupMappingsRequest.Builder, ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse, IdpGroupMapping>(new Supplier<ListIdpGroupMappingsRequest.Builder>(){

            public ListIdpGroupMappingsRequest.Builder get() {
                return ListIdpGroupMappingsRequest.builder().copy(request);
            }
        }, new Function<ListIdpGroupMappingsResponse, String>(){

            public String apply(ListIdpGroupMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder>, ListIdpGroupMappingsRequest>(){

            public ListIdpGroupMappingsRequest apply(RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(){

            public ListIdpGroupMappingsResponse apply(ListIdpGroupMappingsRequest request) {
                return IdentityPaginators.this.client.listIdpGroupMappings(request);
            }
        }, new Function<ListIdpGroupMappingsResponse, List<IdpGroupMapping>>(){

            public List<IdpGroupMapping> apply(ListIdpGroupMappingsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMfaTotpDevicesResponse> listMfaTotpDevicesResponseIterator(final ListMfaTotpDevicesRequest request) {
        return new ResponseIterable<ListMfaTotpDevicesRequest.Builder, ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(new Supplier<ListMfaTotpDevicesRequest.Builder>(){

            public ListMfaTotpDevicesRequest.Builder get() {
                return ListMfaTotpDevicesRequest.builder().copy(request);
            }
        }, new Function<ListMfaTotpDevicesResponse, String>(){

            public String apply(ListMfaTotpDevicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder>, ListMfaTotpDevicesRequest>(){

            public ListMfaTotpDevicesRequest apply(RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(){

            public ListMfaTotpDevicesResponse apply(ListMfaTotpDevicesRequest request) {
                return IdentityPaginators.this.client.listMfaTotpDevices(request);
            }
        });
    }

    public Iterable<MfaTotpDeviceSummary> listMfaTotpDevicesRecordIterator(final ListMfaTotpDevicesRequest request) {
        return new ResponseRecordIterable<ListMfaTotpDevicesRequest.Builder, ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse, MfaTotpDeviceSummary>(new Supplier<ListMfaTotpDevicesRequest.Builder>(){

            public ListMfaTotpDevicesRequest.Builder get() {
                return ListMfaTotpDevicesRequest.builder().copy(request);
            }
        }, new Function<ListMfaTotpDevicesResponse, String>(){

            public String apply(ListMfaTotpDevicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder>, ListMfaTotpDevicesRequest>(){

            public ListMfaTotpDevicesRequest apply(RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(){

            public ListMfaTotpDevicesResponse apply(ListMfaTotpDevicesRequest request) {
                return IdentityPaginators.this.client.listMfaTotpDevices(request);
            }
        }, new Function<ListMfaTotpDevicesResponse, List<MfaTotpDeviceSummary>>(){

            public List<MfaTotpDeviceSummary> apply(ListMfaTotpDevicesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPoliciesResponse> listPoliciesResponseIterator(final ListPoliciesRequest request) {
        return new ResponseIterable<ListPoliciesRequest.Builder, ListPoliciesRequest, ListPoliciesResponse>(new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return IdentityPaginators.this.client.listPolicies(request);
            }
        });
    }

    public Iterable<Policy> listPoliciesRecordIterator(final ListPoliciesRequest request) {
        return new ResponseRecordIterable<ListPoliciesRequest.Builder, ListPoliciesRequest, ListPoliciesResponse, Policy>(new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return IdentityPaginators.this.client.listPolicies(request);
            }
        }, new Function<ListPoliciesResponse, List<Policy>>(){

            public List<Policy> apply(ListPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTagDefaultsResponse> listTagDefaultsResponseIterator(final ListTagDefaultsRequest request) {
        return new ResponseIterable<ListTagDefaultsRequest.Builder, ListTagDefaultsRequest, ListTagDefaultsResponse>(new Supplier<ListTagDefaultsRequest.Builder>(){

            public ListTagDefaultsRequest.Builder get() {
                return ListTagDefaultsRequest.builder().copy(request);
            }
        }, new Function<ListTagDefaultsResponse, String>(){

            public String apply(ListTagDefaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTagDefaultsRequest.Builder>, ListTagDefaultsRequest>(){

            public ListTagDefaultsRequest apply(RequestBuilderAndToken<ListTagDefaultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTagDefaultsRequest, ListTagDefaultsResponse>(){

            public ListTagDefaultsResponse apply(ListTagDefaultsRequest request) {
                return IdentityPaginators.this.client.listTagDefaults(request);
            }
        });
    }

    public Iterable<TagDefaultSummary> listTagDefaultsRecordIterator(final ListTagDefaultsRequest request) {
        return new ResponseRecordIterable<ListTagDefaultsRequest.Builder, ListTagDefaultsRequest, ListTagDefaultsResponse, TagDefaultSummary>(new Supplier<ListTagDefaultsRequest.Builder>(){

            public ListTagDefaultsRequest.Builder get() {
                return ListTagDefaultsRequest.builder().copy(request);
            }
        }, new Function<ListTagDefaultsResponse, String>(){

            public String apply(ListTagDefaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTagDefaultsRequest.Builder>, ListTagDefaultsRequest>(){

            public ListTagDefaultsRequest apply(RequestBuilderAndToken<ListTagDefaultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTagDefaultsRequest, ListTagDefaultsResponse>(){

            public ListTagDefaultsResponse apply(ListTagDefaultsRequest request) {
                return IdentityPaginators.this.client.listTagDefaults(request);
            }
        }, new Function<ListTagDefaultsResponse, List<TagDefaultSummary>>(){

            public List<TagDefaultSummary> apply(ListTagDefaultsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTagNamespacesResponse> listTagNamespacesResponseIterator(final ListTagNamespacesRequest request) {
        return new ResponseIterable<ListTagNamespacesRequest.Builder, ListTagNamespacesRequest, ListTagNamespacesResponse>(new Supplier<ListTagNamespacesRequest.Builder>(){

            public ListTagNamespacesRequest.Builder get() {
                return ListTagNamespacesRequest.builder().copy(request);
            }
        }, new Function<ListTagNamespacesResponse, String>(){

            public String apply(ListTagNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTagNamespacesRequest.Builder>, ListTagNamespacesRequest>(){

            public ListTagNamespacesRequest apply(RequestBuilderAndToken<ListTagNamespacesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTagNamespacesRequest, ListTagNamespacesResponse>(){

            public ListTagNamespacesResponse apply(ListTagNamespacesRequest request) {
                return IdentityPaginators.this.client.listTagNamespaces(request);
            }
        });
    }

    public Iterable<TagNamespaceSummary> listTagNamespacesRecordIterator(final ListTagNamespacesRequest request) {
        return new ResponseRecordIterable<ListTagNamespacesRequest.Builder, ListTagNamespacesRequest, ListTagNamespacesResponse, TagNamespaceSummary>(new Supplier<ListTagNamespacesRequest.Builder>(){

            public ListTagNamespacesRequest.Builder get() {
                return ListTagNamespacesRequest.builder().copy(request);
            }
        }, new Function<ListTagNamespacesResponse, String>(){

            public String apply(ListTagNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTagNamespacesRequest.Builder>, ListTagNamespacesRequest>(){

            public ListTagNamespacesRequest apply(RequestBuilderAndToken<ListTagNamespacesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTagNamespacesRequest, ListTagNamespacesResponse>(){

            public ListTagNamespacesResponse apply(ListTagNamespacesRequest request) {
                return IdentityPaginators.this.client.listTagNamespaces(request);
            }
        }, new Function<ListTagNamespacesResponse, List<TagNamespaceSummary>>(){

            public List<TagNamespaceSummary> apply(ListTagNamespacesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTaggingWorkRequestErrorsResponse> listTaggingWorkRequestErrorsResponseIterator(final ListTaggingWorkRequestErrorsRequest request) {
        return new ResponseIterable<ListTaggingWorkRequestErrorsRequest.Builder, ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>(new Supplier<ListTaggingWorkRequestErrorsRequest.Builder>(){

            public ListTaggingWorkRequestErrorsRequest.Builder get() {
                return ListTaggingWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListTaggingWorkRequestErrorsResponse, String>(){

            public String apply(ListTaggingWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTaggingWorkRequestErrorsRequest.Builder>, ListTaggingWorkRequestErrorsRequest>(){

            public ListTaggingWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListTaggingWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>(){

            public ListTaggingWorkRequestErrorsResponse apply(ListTaggingWorkRequestErrorsRequest request) {
                return IdentityPaginators.this.client.listTaggingWorkRequestErrors(request);
            }
        });
    }

    public Iterable<TaggingWorkRequestErrorSummary> listTaggingWorkRequestErrorsRecordIterator(final ListTaggingWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable<ListTaggingWorkRequestErrorsRequest.Builder, ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse, TaggingWorkRequestErrorSummary>(new Supplier<ListTaggingWorkRequestErrorsRequest.Builder>(){

            public ListTaggingWorkRequestErrorsRequest.Builder get() {
                return ListTaggingWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListTaggingWorkRequestErrorsResponse, String>(){

            public String apply(ListTaggingWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTaggingWorkRequestErrorsRequest.Builder>, ListTaggingWorkRequestErrorsRequest>(){

            public ListTaggingWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListTaggingWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>(){

            public ListTaggingWorkRequestErrorsResponse apply(ListTaggingWorkRequestErrorsRequest request) {
                return IdentityPaginators.this.client.listTaggingWorkRequestErrors(request);
            }
        }, new Function<ListTaggingWorkRequestErrorsResponse, List<TaggingWorkRequestErrorSummary>>(){

            public List<TaggingWorkRequestErrorSummary> apply(ListTaggingWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTaggingWorkRequestLogsResponse> listTaggingWorkRequestLogsResponseIterator(final ListTaggingWorkRequestLogsRequest request) {
        return new ResponseIterable<ListTaggingWorkRequestLogsRequest.Builder, ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>(new Supplier<ListTaggingWorkRequestLogsRequest.Builder>(){

            public ListTaggingWorkRequestLogsRequest.Builder get() {
                return ListTaggingWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListTaggingWorkRequestLogsResponse, String>(){

            public String apply(ListTaggingWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTaggingWorkRequestLogsRequest.Builder>, ListTaggingWorkRequestLogsRequest>(){

            public ListTaggingWorkRequestLogsRequest apply(RequestBuilderAndToken<ListTaggingWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>(){

            public ListTaggingWorkRequestLogsResponse apply(ListTaggingWorkRequestLogsRequest request) {
                return IdentityPaginators.this.client.listTaggingWorkRequestLogs(request);
            }
        });
    }

    public Iterable<TaggingWorkRequestLogSummary> listTaggingWorkRequestLogsRecordIterator(final ListTaggingWorkRequestLogsRequest request) {
        return new ResponseRecordIterable<ListTaggingWorkRequestLogsRequest.Builder, ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse, TaggingWorkRequestLogSummary>(new Supplier<ListTaggingWorkRequestLogsRequest.Builder>(){

            public ListTaggingWorkRequestLogsRequest.Builder get() {
                return ListTaggingWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListTaggingWorkRequestLogsResponse, String>(){

            public String apply(ListTaggingWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTaggingWorkRequestLogsRequest.Builder>, ListTaggingWorkRequestLogsRequest>(){

            public ListTaggingWorkRequestLogsRequest apply(RequestBuilderAndToken<ListTaggingWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>(){

            public ListTaggingWorkRequestLogsResponse apply(ListTaggingWorkRequestLogsRequest request) {
                return IdentityPaginators.this.client.listTaggingWorkRequestLogs(request);
            }
        }, new Function<ListTaggingWorkRequestLogsResponse, List<TaggingWorkRequestLogSummary>>(){

            public List<TaggingWorkRequestLogSummary> apply(ListTaggingWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTaggingWorkRequestsResponse> listTaggingWorkRequestsResponseIterator(final ListTaggingWorkRequestsRequest request) {
        return new ResponseIterable<ListTaggingWorkRequestsRequest.Builder, ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>(new Supplier<ListTaggingWorkRequestsRequest.Builder>(){

            public ListTaggingWorkRequestsRequest.Builder get() {
                return ListTaggingWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListTaggingWorkRequestsResponse, String>(){

            public String apply(ListTaggingWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTaggingWorkRequestsRequest.Builder>, ListTaggingWorkRequestsRequest>(){

            public ListTaggingWorkRequestsRequest apply(RequestBuilderAndToken<ListTaggingWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>(){

            public ListTaggingWorkRequestsResponse apply(ListTaggingWorkRequestsRequest request) {
                return IdentityPaginators.this.client.listTaggingWorkRequests(request);
            }
        });
    }

    public Iterable<TaggingWorkRequestSummary> listTaggingWorkRequestsRecordIterator(final ListTaggingWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListTaggingWorkRequestsRequest.Builder, ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse, TaggingWorkRequestSummary>(new Supplier<ListTaggingWorkRequestsRequest.Builder>(){

            public ListTaggingWorkRequestsRequest.Builder get() {
                return ListTaggingWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListTaggingWorkRequestsResponse, String>(){

            public String apply(ListTaggingWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTaggingWorkRequestsRequest.Builder>, ListTaggingWorkRequestsRequest>(){

            public ListTaggingWorkRequestsRequest apply(RequestBuilderAndToken<ListTaggingWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>(){

            public ListTaggingWorkRequestsResponse apply(ListTaggingWorkRequestsRequest request) {
                return IdentityPaginators.this.client.listTaggingWorkRequests(request);
            }
        }, new Function<ListTaggingWorkRequestsResponse, List<TaggingWorkRequestSummary>>(){

            public List<TaggingWorkRequestSummary> apply(ListTaggingWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTagsResponse> listTagsResponseIterator(final ListTagsRequest request) {
        return new ResponseIterable<ListTagsRequest.Builder, ListTagsRequest, ListTagsResponse>(new Supplier<ListTagsRequest.Builder>(){

            public ListTagsRequest.Builder get() {
                return ListTagsRequest.builder().copy(request);
            }
        }, new Function<ListTagsResponse, String>(){

            public String apply(ListTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTagsRequest.Builder>, ListTagsRequest>(){

            public ListTagsRequest apply(RequestBuilderAndToken<ListTagsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTagsRequest, ListTagsResponse>(){

            public ListTagsResponse apply(ListTagsRequest request) {
                return IdentityPaginators.this.client.listTags(request);
            }
        });
    }

    public Iterable<TagSummary> listTagsRecordIterator(final ListTagsRequest request) {
        return new ResponseRecordIterable<ListTagsRequest.Builder, ListTagsRequest, ListTagsResponse, TagSummary>(new Supplier<ListTagsRequest.Builder>(){

            public ListTagsRequest.Builder get() {
                return ListTagsRequest.builder().copy(request);
            }
        }, new Function<ListTagsResponse, String>(){

            public String apply(ListTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTagsRequest.Builder>, ListTagsRequest>(){

            public ListTagsRequest apply(RequestBuilderAndToken<ListTagsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTagsRequest, ListTagsResponse>(){

            public ListTagsResponse apply(ListTagsRequest request) {
                return IdentityPaginators.this.client.listTags(request);
            }
        }, new Function<ListTagsResponse, List<TagSummary>>(){

            public List<TagSummary> apply(ListTagsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListUserGroupMembershipsResponse> listUserGroupMembershipsResponseIterator(final ListUserGroupMembershipsRequest request) {
        return new ResponseIterable<ListUserGroupMembershipsRequest.Builder, ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(new Supplier<ListUserGroupMembershipsRequest.Builder>(){

            public ListUserGroupMembershipsRequest.Builder get() {
                return ListUserGroupMembershipsRequest.builder().copy(request);
            }
        }, new Function<ListUserGroupMembershipsResponse, String>(){

            public String apply(ListUserGroupMembershipsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder>, ListUserGroupMembershipsRequest>(){

            public ListUserGroupMembershipsRequest apply(RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(){

            public ListUserGroupMembershipsResponse apply(ListUserGroupMembershipsRequest request) {
                return IdentityPaginators.this.client.listUserGroupMemberships(request);
            }
        });
    }

    public Iterable<UserGroupMembership> listUserGroupMembershipsRecordIterator(final ListUserGroupMembershipsRequest request) {
        return new ResponseRecordIterable<ListUserGroupMembershipsRequest.Builder, ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse, UserGroupMembership>(new Supplier<ListUserGroupMembershipsRequest.Builder>(){

            public ListUserGroupMembershipsRequest.Builder get() {
                return ListUserGroupMembershipsRequest.builder().copy(request);
            }
        }, new Function<ListUserGroupMembershipsResponse, String>(){

            public String apply(ListUserGroupMembershipsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder>, ListUserGroupMembershipsRequest>(){

            public ListUserGroupMembershipsRequest apply(RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(){

            public ListUserGroupMembershipsResponse apply(ListUserGroupMembershipsRequest request) {
                return IdentityPaginators.this.client.listUserGroupMemberships(request);
            }
        }, new Function<ListUserGroupMembershipsResponse, List<UserGroupMembership>>(){

            public List<UserGroupMembership> apply(ListUserGroupMembershipsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListUsersResponse> listUsersResponseIterator(final ListUsersRequest request) {
        return new ResponseIterable<ListUsersRequest.Builder, ListUsersRequest, ListUsersResponse>(new Supplier<ListUsersRequest.Builder>(){

            public ListUsersRequest.Builder get() {
                return ListUsersRequest.builder().copy(request);
            }
        }, new Function<ListUsersResponse, String>(){

            public String apply(ListUsersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListUsersRequest.Builder>, ListUsersRequest>(){

            public ListUsersRequest apply(RequestBuilderAndToken<ListUsersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListUsersRequest, ListUsersResponse>(){

            public ListUsersResponse apply(ListUsersRequest request) {
                return IdentityPaginators.this.client.listUsers(request);
            }
        });
    }

    public Iterable<User> listUsersRecordIterator(final ListUsersRequest request) {
        return new ResponseRecordIterable<ListUsersRequest.Builder, ListUsersRequest, ListUsersResponse, User>(new Supplier<ListUsersRequest.Builder>(){

            public ListUsersRequest.Builder get() {
                return ListUsersRequest.builder().copy(request);
            }
        }, new Function<ListUsersResponse, String>(){

            public String apply(ListUsersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListUsersRequest.Builder>, ListUsersRequest>(){

            public ListUsersRequest apply(RequestBuilderAndToken<ListUsersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListUsersRequest, ListUsersResponse>(){

            public ListUsersResponse apply(ListUsersRequest request) {
                return IdentityPaginators.this.client.listUsers(request);
            }
        }, new Function<ListUsersResponse, List<User>>(){

            public List<User> apply(ListUsersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return IdentityPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequestSummary>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return IdentityPaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public IdentityPaginators(Identity client) {
        this.client = client;
    }
}

