/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.identity.requests.CreateIdentityProviderRequest;
import com.oracle.bmc.identity.responses.CreateIdentityProviderResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIdentityProviderConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateIdentityProviderConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateIdentityProviderRequest interceptRequest(CreateIdentityProviderRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateIdentityProviderRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateIdentityProviderDetails(), (String)"createIdentityProviderDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("identityProviders");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateIdentityProviderResponse> fromResponse() {
        Function<Response, CreateIdentityProviderResponse> transformer = new Function<Response, CreateIdentityProviderResponse>(){

            public CreateIdentityProviderResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for CreateIdentityProviderResponse");
                Function<Response, WithHeaders<IdentityProvider>> responseFn = RESPONSE_CONVERSION_FACTORY.create(IdentityProvider.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateIdentityProviderResponse.Builder builder = CreateIdentityProviderResponse.builder();
                builder.identityProvider((IdentityProvider)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                CreateIdentityProviderResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

