/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.IdpGroupMapping;
import com.oracle.bmc.identity.requests.CreateIdpGroupMappingRequest;
import com.oracle.bmc.identity.responses.CreateIdpGroupMappingResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIdpGroupMappingConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateIdpGroupMappingConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateIdpGroupMappingRequest interceptRequest(CreateIdpGroupMappingRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateIdpGroupMappingRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateIdpGroupMappingDetails(), (String)"createIdpGroupMappingDetails is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("identityProviders").path(HttpUtils.encodePathSegment(request.getIdentityProviderId())).path("groupMappings");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateIdpGroupMappingResponse> fromResponse() {
        Function<Response, CreateIdpGroupMappingResponse> transformer = new Function<Response, CreateIdpGroupMappingResponse>(){

            public CreateIdpGroupMappingResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for CreateIdpGroupMappingResponse");
                Function<Response, WithHeaders<IdpGroupMapping>> responseFn = RESPONSE_CONVERSION_FACTORY.create(IdpGroupMapping.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateIdpGroupMappingResponse.Builder builder = CreateIdpGroupMappingResponse.builder();
                builder.idpGroupMapping((IdpGroupMapping)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                CreateIdpGroupMappingResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

