/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.requests.DeleteCustomerSecretKeyRequest;
import com.oracle.bmc.identity.responses.DeleteCustomerSecretKeyResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCustomerSecretKeyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteCustomerSecretKeyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteCustomerSecretKeyRequest interceptRequest(DeleteCustomerSecretKeyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteCustomerSecretKeyRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCustomerSecretKeyId(), (String)"customerSecretKeyId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("users").path(HttpUtils.encodePathSegment(request.getUserId())).path("customerSecretKeys").path(HttpUtils.encodePathSegment(request.getCustomerSecretKeyId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, DeleteCustomerSecretKeyResponse> fromResponse() {
        Function<Response, DeleteCustomerSecretKeyResponse> transformer = new Function<Response, DeleteCustomerSecretKeyResponse>(){

            public DeleteCustomerSecretKeyResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for DeleteCustomerSecretKeyResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                DeleteCustomerSecretKeyResponse.Builder builder = DeleteCustomerSecretKeyResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                DeleteCustomerSecretKeyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

