/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.MfaTotpDevice;
import com.oracle.bmc.identity.requests.GenerateTotpSeedRequest;
import com.oracle.bmc.identity.responses.GenerateTotpSeedResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTotpSeedConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateTotpSeedConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GenerateTotpSeedRequest interceptRequest(GenerateTotpSeedRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GenerateTotpSeedRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMfaTotpDeviceId(), (String)"mfaTotpDeviceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("users").path(HttpUtils.encodePathSegment(request.getUserId())).path("mfaTotpDevices").path(HttpUtils.encodePathSegment(request.getMfaTotpDeviceId())).path("actions").path("generateSeed");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, GenerateTotpSeedResponse> fromResponse() {
        Function<Response, GenerateTotpSeedResponse> transformer = new Function<Response, GenerateTotpSeedResponse>(){

            public GenerateTotpSeedResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for GenerateTotpSeedResponse");
                Function<Response, WithHeaders<MfaTotpDevice>> responseFn = RESPONSE_CONVERSION_FACTORY.create(MfaTotpDevice.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GenerateTotpSeedResponse.Builder builder = GenerateTotpSeedResponse.builder();
                builder.mfaTotpDevice((MfaTotpDevice)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                GenerateTotpSeedResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

