/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.CustomerSecretKeySummary;
import com.oracle.bmc.identity.requests.ListCustomerSecretKeysRequest;
import com.oracle.bmc.identity.responses.ListCustomerSecretKeysResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCustomerSecretKeysConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListCustomerSecretKeysConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListCustomerSecretKeysRequest interceptRequest(ListCustomerSecretKeysRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListCustomerSecretKeysRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("users").path(HttpUtils.encodePathSegment(request.getUserId())).path("customerSecretKeys");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListCustomerSecretKeysResponse> fromResponse() {
        Function<Response, ListCustomerSecretKeysResponse> transformer = new Function<Response, ListCustomerSecretKeysResponse>(){

            public ListCustomerSecretKeysResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListCustomerSecretKeysResponse");
                Function<Response, WithHeaders<List<CustomerSecretKeySummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<CustomerSecretKeySummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListCustomerSecretKeysResponse.Builder builder = ListCustomerSecretKeysResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                ListCustomerSecretKeysResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

