/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTagDefaultsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTagDefaultsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTagDefaultsRequest interceptRequest(ListTagDefaultsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTagDefaultsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("tagDefaults");
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getId() != null) {
            target = target.queryParam("id", HttpUtils.attemptEncodeQueryParam(request.getId()));
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        }
        if (request.getTagDefinitionId() != null) {
            target = target.queryParam("tagDefinitionId", HttpUtils.attemptEncodeQueryParam(request.getTagDefinitionId()));
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", HttpUtils.attemptEncodeQueryParam(request.getLifecycleState().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListTagDefaultsResponse> fromResponse() {
        Function<Response, ListTagDefaultsResponse> transformer = new Function<Response, ListTagDefaultsResponse>(){

            public ListTagDefaultsResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListTagDefaultsResponse");
                Function<Response, WithHeaders<List<TagDefaultSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<TagDefaultSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListTagDefaultsResponse.Builder builder = ListTagDefaultsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                ListTagDefaultsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

