/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.TaggingWorkRequestLogSummary;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestLogsRequest;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestLogsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTaggingWorkRequestLogsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTaggingWorkRequestLogsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTaggingWorkRequestLogsRequest interceptRequest(ListTaggingWorkRequestLogsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTaggingWorkRequestLogsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("taggingWorkRequests").path(HttpUtils.encodePathSegment(request.getWorkRequestId())).path("logs");
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListTaggingWorkRequestLogsResponse> fromResponse() {
        Function<Response, ListTaggingWorkRequestLogsResponse> transformer = new Function<Response, ListTaggingWorkRequestLogsResponse>(){

            public ListTaggingWorkRequestLogsResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                Optional<List<String>> retryAfterHeader;
                LOG.trace("Transform function invoked for ListTaggingWorkRequestLogsResponse");
                Function<Response, WithHeaders<List<TaggingWorkRequestLogSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<TaggingWorkRequestLogSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListTaggingWorkRequestLogsResponse.Builder builder = ListTaggingWorkRequestLogsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get(headers, "retry-after")).isPresent()) {
                    builder.retryAfter(HeaderUtils.toValue("retry-after", (String)((List)retryAfterHeader.get()).get(0), Float.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                ListTaggingWorkRequestLogsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

