/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.ScimClientCredentials;
import com.oracle.bmc.identity.requests.ResetIdpScimClientRequest;
import com.oracle.bmc.identity.responses.ResetIdpScimClientResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetIdpScimClientConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ResetIdpScimClientConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ResetIdpScimClientRequest interceptRequest(ResetIdpScimClientRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ResetIdpScimClientRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("identityProviders").path(HttpUtils.encodePathSegment(request.getIdentityProviderId())).path("actions").path("resetScimClient");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ResetIdpScimClientResponse> fromResponse() {
        Function<Response, ResetIdpScimClientResponse> transformer = new Function<Response, ResetIdpScimClientResponse>(){

            public ResetIdpScimClientResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ResetIdpScimClientResponse");
                Function<Response, WithHeaders<ScimClientCredentials>> responseFn = RESPONSE_CONVERSION_FACTORY.create(ScimClientCredentials.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ResetIdpScimClientResponse.Builder builder = ResetIdpScimClientResponse.builder();
                builder.scimClientCredentials((ScimClientCredentials)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ResetIdpScimClientResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

