/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.identity.requests.UpdateTagRequest;
import com.oracle.bmc.identity.responses.UpdateTagResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTagConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTagConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateTagRequest interceptRequest(UpdateTagRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateTagRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTagName(), (String)"tagName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateTagDetails(), (String)"updateTagDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("tagNamespaces").path(HttpUtils.encodePathSegment(request.getTagNamespaceId())).path("tags").path(HttpUtils.encodePathSegment(request.getTagName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateTagResponse> fromResponse() {
        Function<Response, UpdateTagResponse> transformer = new Function<Response, UpdateTagResponse>(){

            public UpdateTagResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for UpdateTagResponse");
                Function<Response, WithHeaders<Tag>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Tag.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateTagResponse.Builder builder = UpdateTagResponse.builder();
                builder.tag((Tag)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                UpdateTagResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

