/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreateGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateGroupRequest
extends BmcRequest {
    private CreateGroupDetails createGroupDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createGroupDetails", "opcRetryToken"})
    CreateGroupRequest(CreateGroupDetails createGroupDetails, String opcRetryToken) {
        this.createGroupDetails = createGroupDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateGroupDetails getCreateGroupDetails() {
        return this.createGroupDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateGroupDetails createGroupDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateGroupRequest o) {
            this.createGroupDetails(o.getCreateGroupDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateGroupRequest build() {
            CreateGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createGroupDetails(CreateGroupDetails createGroupDetails) {
            this.createGroupDetails = createGroupDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateGroupRequest buildWithoutInvocationCallback() {
            return new CreateGroupRequest(this.createGroupDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateGroupRequest.Builder(createGroupDetails=" + this.createGroupDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

