/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTagRequest
extends BmcRequest {
    private String tagNamespaceId;
    private CreateTagDetails createTagDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"tagNamespaceId", "createTagDetails", "opcRetryToken"})
    CreateTagRequest(String tagNamespaceId, CreateTagDetails createTagDetails, String opcRetryToken) {
        this.tagNamespaceId = tagNamespaceId;
        this.createTagDetails = createTagDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public CreateTagDetails getCreateTagDetails() {
        return this.createTagDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String tagNamespaceId;
        private CreateTagDetails createTagDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTagRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.createTagDetails(o.getCreateTagDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTagRequest build() {
            CreateTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder createTagDetails(CreateTagDetails createTagDetails) {
            this.createTagDetails = createTagDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateTagRequest buildWithoutInvocationCallback() {
            return new CreateTagRequest(this.tagNamespaceId, this.createTagDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateTagRequest.Builder(tagNamespaceId=" + this.tagNamespaceId + ", createTagDetails=" + this.createTagDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

