/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteCustomerSecretKeyRequest
extends BmcRequest {
    private String userId;
    private String customerSecretKeyId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "customerSecretKeyId", "ifMatch"})
    DeleteCustomerSecretKeyRequest(String userId, String customerSecretKeyId, String ifMatch) {
        this.userId = userId;
        this.customerSecretKeyId = customerSecretKeyId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCustomerSecretKeyId() {
        return this.customerSecretKeyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String customerSecretKeyId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCustomerSecretKeyRequest o) {
            this.userId(o.getUserId());
            this.customerSecretKeyId(o.getCustomerSecretKeyId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCustomerSecretKeyRequest build() {
            DeleteCustomerSecretKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder customerSecretKeyId(String customerSecretKeyId) {
            this.customerSecretKeyId = customerSecretKeyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteCustomerSecretKeyRequest buildWithoutInvocationCallback() {
            return new DeleteCustomerSecretKeyRequest(this.userId, this.customerSecretKeyId, this.ifMatch);
        }

        public String toString() {
            return "DeleteCustomerSecretKeyRequest.Builder(userId=" + this.userId + ", customerSecretKeyId=" + this.customerSecretKeyId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

