/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteMfaTotpDeviceRequest
extends BmcRequest {
    private String userId;
    private String mfaTotpDeviceId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "mfaTotpDeviceId", "ifMatch"})
    DeleteMfaTotpDeviceRequest(String userId, String mfaTotpDeviceId, String ifMatch) {
        this.userId = userId;
        this.mfaTotpDeviceId = mfaTotpDeviceId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMfaTotpDeviceId() {
        return this.mfaTotpDeviceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String mfaTotpDeviceId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteMfaTotpDeviceRequest o) {
            this.userId(o.getUserId());
            this.mfaTotpDeviceId(o.getMfaTotpDeviceId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteMfaTotpDeviceRequest build() {
            DeleteMfaTotpDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder mfaTotpDeviceId(String mfaTotpDeviceId) {
            this.mfaTotpDeviceId = mfaTotpDeviceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteMfaTotpDeviceRequest buildWithoutInvocationCallback() {
            return new DeleteMfaTotpDeviceRequest(this.userId, this.mfaTotpDeviceId, this.ifMatch);
        }

        public String toString() {
            return "DeleteMfaTotpDeviceRequest.Builder(userId=" + this.userId + ", mfaTotpDeviceId=" + this.mfaTotpDeviceId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

