/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetIdentityProviderRequest
extends BmcRequest {
    private String identityProviderId;

    @ConstructorProperties(value={"identityProviderId"})
    GetIdentityProviderRequest(String identityProviderId) {
        this.identityProviderId = identityProviderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public static class Builder {
        private String identityProviderId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIdentityProviderRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIdentityProviderRequest build() {
            GetIdentityProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public GetIdentityProviderRequest buildWithoutInvocationCallback() {
            return new GetIdentityProviderRequest(this.identityProviderId);
        }

        public String toString() {
            return "GetIdentityProviderRequest.Builder(identityProviderId=" + this.identityProviderId + ")";
        }
    }
}

