/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetMfaTotpDeviceRequest
extends BmcRequest {
    private String userId;
    private String mfaTotpDeviceId;

    @ConstructorProperties(value={"userId", "mfaTotpDeviceId"})
    GetMfaTotpDeviceRequest(String userId, String mfaTotpDeviceId) {
        this.userId = userId;
        this.mfaTotpDeviceId = mfaTotpDeviceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMfaTotpDeviceId() {
        return this.mfaTotpDeviceId;
    }

    public static class Builder {
        private String userId;
        private String mfaTotpDeviceId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMfaTotpDeviceRequest o) {
            this.userId(o.getUserId());
            this.mfaTotpDeviceId(o.getMfaTotpDeviceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMfaTotpDeviceRequest build() {
            GetMfaTotpDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder mfaTotpDeviceId(String mfaTotpDeviceId) {
            this.mfaTotpDeviceId = mfaTotpDeviceId;
            return this;
        }

        public GetMfaTotpDeviceRequest buildWithoutInvocationCallback() {
            return new GetMfaTotpDeviceRequest(this.userId, this.mfaTotpDeviceId);
        }

        public String toString() {
            return "GetMfaTotpDeviceRequest.Builder(userId=" + this.userId + ", mfaTotpDeviceId=" + this.mfaTotpDeviceId + ")";
        }
    }
}

