/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListCompartmentsRequest
extends BmcRequest {
    private String compartmentId;
    private String page;
    private Integer limit;
    private AccessLevel accessLevel;
    private Boolean compartmentIdInSubtree;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "accessLevel", "compartmentIdInSubtree"})
    ListCompartmentsRequest(String compartmentId, String page, Integer limit, AccessLevel accessLevel, Boolean compartmentIdInSubtree) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.accessLevel = accessLevel;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public static class Builder {
        private String compartmentId;
        private String page;
        private Integer limit;
        private AccessLevel accessLevel;
        private Boolean compartmentIdInSubtree;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCompartmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.accessLevel(o.getAccessLevel());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCompartmentsRequest build() {
            ListCompartmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public ListCompartmentsRequest buildWithoutInvocationCallback() {
            return new ListCompartmentsRequest(this.compartmentId, this.page, this.limit, this.accessLevel, this.compartmentIdInSubtree);
        }

        public String toString() {
            return "ListCompartmentsRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ")";
        }
    }

    public static enum AccessLevel {
        Any("ANY"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

