/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListIdpGroupMappingsRequest
extends BmcRequest {
    private String identityProviderId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"identityProviderId", "page", "limit"})
    ListIdpGroupMappingsRequest(String identityProviderId, String page, Integer limit) {
        this.identityProviderId = identityProviderId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder {
        private String identityProviderId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIdpGroupMappingsRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIdpGroupMappingsRequest build() {
            ListIdpGroupMappingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListIdpGroupMappingsRequest buildWithoutInvocationCallback() {
            return new ListIdpGroupMappingsRequest(this.identityProviderId, this.page, this.limit);
        }

        public String toString() {
            return "ListIdpGroupMappingsRequest.Builder(identityProviderId=" + this.identityProviderId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

