/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTagsRequest
extends BmcRequest {
    private String tagNamespaceId;
    private String page;
    private Integer limit;
    private Tag.LifecycleState lifecycleState;

    @ConstructorProperties(value={"tagNamespaceId", "page", "limit", "lifecycleState"})
    ListTagsRequest(String tagNamespaceId, String page, Integer limit, Tag.LifecycleState lifecycleState) {
        this.tagNamespaceId = tagNamespaceId;
        this.page = page;
        this.limit = limit;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Tag.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder {
        private String tagNamespaceId;
        private String page;
        private Integer limit;
        private Tag.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagsRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagsRequest build() {
            ListTagsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder lifecycleState(Tag.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListTagsRequest buildWithoutInvocationCallback() {
            return new ListTagsRequest(this.tagNamespaceId, this.page, this.limit, this.lifecycleState);
        }

        public String toString() {
            return "ListTagsRequest.Builder(tagNamespaceId=" + this.tagNamespaceId + ", page=" + this.page + ", limit=" + this.limit + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

