/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListUsersRequest
extends BmcRequest {
    private String compartmentId;
    private String page;
    private Integer limit;
    private String identityProviderId;
    private String externalIdentifier;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "identityProviderId", "externalIdentifier"})
    ListUsersRequest(String compartmentId, String page, Integer limit, String identityProviderId, String externalIdentifier) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.identityProviderId = identityProviderId;
        this.externalIdentifier = externalIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public static class Builder {
        private String compartmentId;
        private String page;
        private Integer limit;
        private String identityProviderId;
        private String externalIdentifier;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUsersRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.identityProviderId(o.getIdentityProviderId());
            this.externalIdentifier(o.getExternalIdentifier());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUsersRequest build() {
            ListUsersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public ListUsersRequest buildWithoutInvocationCallback() {
            return new ListUsersRequest(this.compartmentId, this.page, this.limit, this.identityProviderId, this.externalIdentifier);
        }

        public String toString() {
            return "ListUsersRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", identityProviderId=" + this.identityProviderId + ", externalIdentifier=" + this.externalIdentifier + ")";
        }
    }
}

